/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.Registry;
import com.sk89q.worldedit.registry.RegistryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class NamespacedRegistry<V extends Keyed>
extends Registry<V> {
    private static final String MINECRAFT_NAMESPACE = "minecraft";
    private final Set<String> knownNamespaces = new HashSet<String>();
    private final String defaultNamespace;
    private final List<V> values = new ArrayList<V>();
    private int lastInternalId = 0;

    public NamespacedRegistry(String name) {
        this(name, MINECRAFT_NAMESPACE);
    }

    public NamespacedRegistry(String name, String defaultNamespace) {
        super(name);
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    @Nullable
    public V get(String key) {
        return super.get(this.orDefaultNamespace(key));
    }

    @Override
    public synchronized V register(String key, V value) {
        Objects.requireNonNull(key, "key");
        int i = key.indexOf(58);
        Preconditions.checkState((i > 0 ? 1 : 0) != 0, (Object)"key is not namespaced");
        if (value instanceof RegistryItem) {
            ((RegistryItem)value).setInternalId(this.lastInternalId++);
        }
        this.values.add(value);
        V registered = super.register(key, value);
        this.knownNamespaces.add(key.substring(0, i));
        return registered;
    }

    public V getByInternalId(int index) {
        try {
            return (V)((Keyed)this.values.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int size() {
        return this.values.size();
    }

    public Set<String> getKnownNamespaces() {
        return Collections.unmodifiableSet(this.knownNamespaces);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private String orDefaultNamespace(String key) {
        if (key.indexOf(58) == -1) {
            return this.defaultNamespace + ':' + key;
        }
        return key;
    }

    public <V1 extends Keyed> Stream<String> getSuggestions(String input) {
        return SuggestionHelper.getNamespacedRegistrySuggestions(this, input);
    }
}

