/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.sk89q.worldedit.registry.state.AbstractProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class EnumProperty
extends AbstractProperty<String> {
    private Map<CharSequence, Integer> offsets = new HashMap<CharSequence, Integer>();

    public EnumProperty(String name, List<String> values) {
        this(name, values, 0);
    }

    private EnumProperty(String name, List<String> values, int bitOffset) {
        super(name, values, bitOffset);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i).intern();
            values.set(i, value);
            this.offsets.put(value, i);
        }
    }

    @Override
    public EnumProperty withOffset(int bitOffset) {
        return new EnumProperty(this.getName(), this.getValues(), bitOffset);
    }

    @Override
    public int getIndexFor(CharSequence string) throws IllegalArgumentException {
        Integer value = this.offsets.get(string);
        return value == null ? -1 : value;
    }

    @Override
    @Nullable
    public String getValueFor(String string) {
        Integer offset = this.offsets.get(string);
        if (offset == null) {
            throw new IllegalArgumentException("Invalid value: " + string + ". Must be in " + this.getValues().toString());
        }
        return (String)this.getValues().get(offset);
    }
}

