/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.session;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.transform.Identity;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.PasteBuilder;
import java.util.Collections;
import java.util.List;

public class ClipboardHolder {
    private Clipboard clipboard;
    private Transform transform = new Identity();

    public ClipboardHolder(Clipboard clipboard) {
        Preconditions.checkNotNull((Object)clipboard);
        this.clipboard = clipboard;
    }

    @Deprecated
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public List<Clipboard> getClipboards() {
        return Collections.singletonList(this.getClipboard());
    }

    public boolean contains(Clipboard clipboard) {
        return this.clipboard == clipboard;
    }

    public List<ClipboardHolder> getHolders() {
        return Collections.singletonList(this);
    }

    public void setTransform(Transform transform) {
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public PasteBuilder createPaste(Extent targetExtent) {
        return new PasteBuilder(this, targetExtent);
    }

    public void close() {
        if (this.clipboard != null) {
            this.clipboard.close();
        }
        this.clipboard = null;
    }
}

