/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public enum Direction {
    NORTH(Vector3.at(0.0, 0.0, -1.0), Flag.CARDINAL, 3, 1),
    EAST(Vector3.at(1.0, 0.0, 0.0), Flag.CARDINAL, 0, 2),
    SOUTH(Vector3.at(0.0, 0.0, 1.0), Flag.CARDINAL, 1, 3),
    WEST(Vector3.at(-1.0, 0.0, 0.0), Flag.CARDINAL, 2, 0),
    UP(Vector3.at(0.0, 1.0, 0.0), Flag.UPRIGHT, -1, -1),
    DOWN(Vector3.at(0.0, -1.0, 0.0), Flag.UPRIGHT, -1, -1),
    NORTHEAST(Vector3.at(1.0, 0.0, -1.0), Flag.ORDINAL, 7, 8),
    NORTHWEST(Vector3.at(-1.0, 0.0, -1.0), Flag.ORDINAL, 9, 6),
    SOUTHEAST(Vector3.at(1.0, 0.0, 1.0), Flag.ORDINAL, 6, 9),
    SOUTHWEST(Vector3.at(-1.0, 0.0, 1.0), Flag.ORDINAL, 8, 7),
    WEST_NORTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 9, 6),
    WEST_SOUTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 8, 7),
    NORTH_NORTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 9, 6),
    NORTH_NORTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 7, 8),
    EAST_NORTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 7, 8),
    EAST_SOUTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 6, 9),
    SOUTH_SOUTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 6, 9),
    SOUTH_SOUTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 8, 7),
    ASCENDING_NORTH(Vector3.at(0.0, 1.0, -1.0), Flag.ASCENDING_CARDINAL, 21, 19),
    ASCENDING_EAST(Vector3.at(1.0, 1.0, 0.0), Flag.ASCENDING_CARDINAL, 18, 20),
    ASCENDING_SOUTH(Vector3.at(0.0, 1.0, 1.0), Flag.ASCENDING_CARDINAL, 19, 21),
    ASCENDING_WEST(Vector3.at(-1.0, 1.0, 0.0), Flag.ASCENDING_CARDINAL, 20, 18);

    private final Vector3 direction;
    private final int flags;
    private final int left;
    private final int right;
    private final BlockVector3 blockPoint;
    private static HashMap<String, Direction> map;

    private Direction(Vector3 vector, int flags, int left, int right) {
        this.blockPoint = BlockVector3.at(MathMan.roundInt(Math.signum(vector.getX())), MathMan.roundInt(Math.signum(vector.getY())), MathMan.roundInt(Math.signum(vector.getZ())));
        this.direction = vector.normalize();
        this.flags = flags;
        this.left = left;
        this.right = right;
    }

    public static Direction get(CharSequence sequence) {
        return map.get(sequence);
    }

    public Direction getLeft() {
        return this.left != -1 ? Direction.values()[this.left] : null;
    }

    public Direction getRight() {
        return this.right != -1 ? Direction.values()[this.right] : null;
    }

    public double getX() {
        return this.direction.getX();
    }

    public double getY() {
        return this.direction.getY();
    }

    public double getZ() {
        return this.direction.getZ();
    }

    public int getBlockX() {
        return this.blockPoint.getX();
    }

    public int getBlockY() {
        return this.blockPoint.getY();
    }

    public int getBlockZ() {
        return this.blockPoint.getZ();
    }

    public boolean isCardinal() {
        return (this.flags & Flag.CARDINAL) > 0;
    }

    public boolean isOrdinal() {
        return (this.flags & Flag.ORDINAL) > 0;
    }

    public boolean isSecondaryOrdinal() {
        return (this.flags & Flag.SECONDARY_ORDINAL) > 0;
    }

    public boolean isUpright() {
        return (this.flags & Flag.UPRIGHT) > 0;
    }

    public Vector3 toVector() {
        return this.direction;
    }

    public BlockVector3 toBlockVector() {
        return this.blockPoint;
    }

    @Nullable
    public static Direction findClosest(Vector3 vector, int flags) {
        if ((flags & Flag.UPRIGHT) == 0) {
            vector = vector.withY(0.0);
        }
        vector = vector.normalize();
        Direction closest = null;
        double closestDot = -2.0;
        for (Direction direction : Direction.values()) {
            double dot;
            if ((~flags & direction.flags) > 0 || !((dot = direction.toVector().dot(vector)) >= closestDot)) continue;
            closest = direction;
            closestDot = dot;
        }
        return closest;
    }

    public static List<Direction> valuesOf(int flags) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if ((~flags & direction.flags) != 0) continue;
            directions.add(direction);
        }
        return directions;
    }

    public static Optional<Direction> fromRotationIndex(int rotation) {
        switch (rotation) {
            case 0: {
                return Optional.of(SOUTH);
            }
            case 1: {
                return Optional.of(SOUTH_SOUTHWEST);
            }
            case 2: {
                return Optional.of(SOUTHWEST);
            }
            case 3: {
                return Optional.of(WEST_SOUTHWEST);
            }
            case 4: {
                return Optional.of(WEST);
            }
            case 5: {
                return Optional.of(WEST_NORTHWEST);
            }
            case 6: {
                return Optional.of(NORTHWEST);
            }
            case 7: {
                return Optional.of(NORTH_NORTHWEST);
            }
            case 8: {
                return Optional.of(NORTH);
            }
            case 9: {
                return Optional.of(NORTH_NORTHEAST);
            }
            case 10: {
                return Optional.of(NORTHEAST);
            }
            case 11: {
                return Optional.of(EAST_NORTHEAST);
            }
            case 12: {
                return Optional.of(EAST);
            }
            case 13: {
                return Optional.of(EAST_SOUTHEAST);
            }
            case 14: {
                return Optional.of(SOUTHEAST);
            }
            case 15: {
                return Optional.of(SOUTH_SOUTHEAST);
            }
        }
        return Optional.empty();
    }

    public OptionalInt toRotationIndex() {
        switch (this) {
            case SOUTH: {
                return OptionalInt.of(0);
            }
            case SOUTH_SOUTHWEST: {
                return OptionalInt.of(1);
            }
            case SOUTHWEST: {
                return OptionalInt.of(2);
            }
            case WEST_SOUTHWEST: {
                return OptionalInt.of(3);
            }
            case WEST: {
                return OptionalInt.of(4);
            }
            case WEST_NORTHWEST: {
                return OptionalInt.of(5);
            }
            case NORTHWEST: {
                return OptionalInt.of(6);
            }
            case NORTH_NORTHWEST: {
                return OptionalInt.of(7);
            }
            case NORTH: {
                return OptionalInt.of(8);
            }
            case NORTH_NORTHEAST: {
                return OptionalInt.of(9);
            }
            case NORTHEAST: {
                return OptionalInt.of(10);
            }
            case EAST_NORTHEAST: {
                return OptionalInt.of(11);
            }
            case EAST: {
                return OptionalInt.of(12);
            }
            case EAST_SOUTHEAST: {
                return OptionalInt.of(13);
            }
            case SOUTHEAST: {
                return OptionalInt.of(14);
            }
            case SOUTH_SOUTHEAST: {
                return OptionalInt.of(15);
            }
        }
        return OptionalInt.empty();
    }

    static {
        map = new HashMap();
        for (Direction dir : Direction.values()) {
            map.put(dir.name(), dir);
            map.put(dir.name().toLowerCase(Locale.ROOT), dir);
        }
    }

    public static final class Flag {
        public static int CARDINAL = 1;
        public static int ORDINAL = 2;
        public static int SECONDARY_ORDINAL = 4;
        public static int UPRIGHT = 8;
        public static int ASCENDING_CARDINAL = 15;
        public static int ALL = CARDINAL | ORDINAL | SECONDARY_ORDINAL | UPRIGHT | ASCENDING_CARDINAL;

        private Flag() {
        }
    }
}

