/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world;

import com.boydti.fawe.Fawe;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.nio.file.Path;
import javax.annotation.Nullable;

public interface SimpleWorld
extends World {
    @Override
    default public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        return false;
    }

    @Override
    default public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        return this.setBlock(position, block);
    }

    @Override
    default public BaseBlock getFullBlock(BlockVector3 position) {
        return this.getBlock(position).toBaseBlock();
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 var1, B var2) throws WorldEditException;

    @Override
    @Nullable
    default public Path getStoragePath() {
        return null;
    }

    @Override
    default public int getMaxY() {
        return this.getMaximumPoint().getBlockY();
    }

    @Override
    default public Mask createLiquidMask() {
        return new BlockMask(this).add(BlockTypes.LAVA, BlockTypes.WATER);
    }

    @Override
    default public void dropItem(Vector3 pt, BaseItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            this.dropItem(pt, item);
        }
    }

    @Override
    default public void checkLoadedChunk(BlockVector3 pt) {
    }

    @Override
    default public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
    }

    @Override
    default public void fixLighting(Iterable<BlockVector2> chunks) {
    }

    default public boolean playEffect(BlockVector3 position, int type, int data) {
        return false;
    }

    @Override
    default public boolean queueBlockBreakEffect(Platform server, BlockVector3 position, BlockType blockType, double priority) {
        Fawe.get().getQueueHandler().sync(() -> this.playEffect(position, 2001, blockType.getLegacyCombinedId() >> 4));
        return true;
    }

    @Override
    default public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(-30000000, 0, -30000000);
    }

    @Override
    default public BlockVector3 getMaximumPoint() {
        return BlockVector3.at(30000000, 255, 30000000);
    }

    @Override
    default public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) throws MaxChangedBlocksException {
        return false;
    }

    @Override
    default public void simulateBlockMine(BlockVector3 position) {
        try {
            this.setBlock(position, (B)BlockTypes.AIR.getDefaultState());
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public WeatherType getWeather() {
        return WeatherTypes.CLEAR;
    }

    @Override
    default public long getRemainingWeatherDuration() {
        return 0L;
    }

    @Override
    default public void setWeather(WeatherType weatherType) {
    }

    @Override
    default public void setWeather(WeatherType weatherType, long duration) {
    }
}

