/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class BaseBlock
implements BlockStateHolder<BaseBlock>,
TileEntityBlock {
    private final BlockState blockState;
    @Nullable
    private final CompoundTag nbtData;

    @Deprecated
    public BaseBlock(BlockType blockType) {
        this(blockType.getDefaultState());
    }

    public BaseBlock(BlockState blockState) {
        this.blockState = blockState;
        this.nbtData = null;
    }

    public BaseBlock(BlockState state, CompoundTag nbtData) {
        Preconditions.checkNotNull((Object)nbtData);
        this.blockState = state;
        this.nbtData = nbtData;
    }

    @Deprecated
    public BaseBlock(int id, int data) {
        this(BaseBlock.getState(id, data));
    }

    public static BlockState getState(int id, int data) {
        BlockState blockState = LegacyMapper.getInstance().getBlockFromLegacy(id, data);
        if (blockState == null) {
            blockState = BlockTypes.AIR.getDefaultState();
        }
        return blockState;
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return this.toImmutableState().getStates();
    }

    @Override
    public BlockType getBlockType() {
        return this.blockState.getBlockType();
    }

    @Override
    public <V> BaseBlock with(Property<V> property, V value) {
        return ((BlockState)this.toImmutableState().with((Property)property, (Object)value)).toBaseBlock(this.getNbtData());
    }

    @Override
    public <V> V getState(Property<V> property) {
        return this.toImmutableState().getState(property);
    }

    @Override
    public boolean hasNbtData() {
        return this.getNbtData() != null;
    }

    @Override
    public String getNbtId() {
        CompoundTag nbtData = this.getNbtData();
        if (nbtData == null) {
            return "";
        }
        Tag idTag = (Tag)nbtData.getValue().get("id");
        if (idTag == null) {
            idTag = (Tag)nbtData.getValue().get("Id");
        }
        if (idTag instanceof StringTag) {
            return ((StringTag)idTag).getValue();
        }
        return "";
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseBlock)) {
            if (!this.hasNbtData() && o instanceof BlockStateHolder) {
                return Objects.equals(this.toImmutableState(), ((BlockStateHolder)o).toImmutableState());
            }
            return false;
        }
        BaseBlock otherBlock = (BaseBlock)o;
        return this.blockState.equalsFuzzy(otherBlock.blockState) && Objects.equals(this.getNbtData(), otherBlock.getNbtData());
    }

    @Override
    public int getInternalId() {
        return this.blockState.getInternalId();
    }

    @Override
    public BlockMaterial getMaterial() {
        return this.blockState.getMaterial();
    }

    @Override
    public int getOrdinal() {
        return this.blockState.getOrdinal();
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        return this.blockState.equalsFuzzy(o);
    }

    @Override
    public BlockState toImmutableState() {
        return this.blockState;
    }

    @Override
    public final char getOrdinalChar() {
        return this.blockState.getOrdinalChar();
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this;
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        set.setFullBlock(extent, this);
        return true;
    }

    @Override
    public void applyTileEntity(OutputExtent output, int x, int y, int z) {
        CompoundTag nbt = this.getNbtData();
        if (nbt != null) {
            output.setTile(x, y, z, nbt);
        }
    }

    @Override
    public BaseBlock withPropertyId(int propertyId) {
        return this.getBlockType().withPropertyId(propertyId).toBaseBlock(this.getNbtData());
    }

    @Override
    public int getInternalBlockTypeId() {
        return this.toImmutableState().getInternalBlockTypeId();
    }

    @Override
    public int getInternalPropertiesId() {
        return this.toImmutableState().getInternalPropertiesId();
    }

    @Override
    public <V> BaseBlock with(PropertyKey property, V value) {
        return ((BlockState)this.toImmutableState().with(property, (Object)value)).toBaseBlock(this.getNbtData());
    }

    @Override
    public BaseBlock toBaseBlock(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return this.blockState.toBaseBlock();
        }
        if (compoundTag == this.nbtData) {
            return this;
        }
        return new BaseBlock(this.blockState, compoundTag);
    }

    @Override
    public <V> V getState(PropertyKey property) {
        return this.toImmutableState().getState(property);
    }

    public int hashCode() {
        return this.getOrdinal();
    }

    public String toString() {
        return this.blockState.getAsString() + (this.hasNbtData() ? "{hasNbt}" : "");
    }

    public BlockState toBlockState() {
        return this.blockState;
    }
}

