/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.boydti.fawe.beta.ITileInput;
import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.object.string.MutableCharSequence;
import com.boydti.fawe.util.StringMan;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.SingleBlockStateMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.block.CompoundInput;
import com.sk89q.worldedit.world.block.ImmutableBaseBlock;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class BlockState
implements BlockStateHolder<BlockState>,
Pattern {
    private final int internalId;
    private final int ordinal;
    private final char ordinalChar;
    private final BlockType blockType;
    private BlockMaterial material;
    private final BaseBlock emptyBaseBlock;
    private CompoundInput compoundInput = CompoundInput.NULL;

    protected BlockState(BlockType blockType, int internalId, int ordinal) {
        this.blockType = blockType;
        this.internalId = internalId;
        this.ordinal = ordinal;
        this.ordinalChar = (char)ordinal;
        this.emptyBaseBlock = new ImmutableBaseBlock(this);
    }

    @Deprecated
    public static BlockState getFromInternalId(int combinedId) throws InputParseException {
        return BlockTypes.getFromStateId(combinedId).withStateId(combinedId);
    }

    @Deprecated
    public static BlockState getFromOrdinal(int ordinal) {
        return BlockTypesCache.states[ordinal];
    }

    public static BlockState get(String state) throws InputParseException {
        return BlockState.get(null, state);
    }

    public static BlockState get(@Nullable BlockType type, String state) throws InputParseException {
        return BlockState.get(type, state, null);
    }

    public static BlockState get(@Nullable BlockType type, String state, BlockState defaultState) throws InputParseException {
        int last;
        MutableCharSequence charSequence;
        int propStrStart = state.indexOf(91);
        if (type == null) {
            CharSequence key;
            if (propStrStart == -1) {
                key = state;
            } else {
                charSequence = MutableCharSequence.getTemporal();
                charSequence.setString(state);
                charSequence.setSubstring(0, propStrStart);
                key = charSequence;
            }
            type = BlockTypes.get(key);
            if (type == null) {
                String input = key.toString();
                throw new SuggestInputParseException("Does not match a valid block type: " + input, input, () -> Stream.of(BlockTypesCache.values).filter(b -> StringMan.blockStateMatches(input, b.getId())).map(BlockType::getId).sorted(StringMan.blockStateComparator(input)).collect(Collectors.toList()));
            }
        }
        if (propStrStart == -1) {
            return type.getDefaultState();
        }
        List<Property<?>> propList = type.getProperties();
        if (state.charAt(state.length() - 1) != ']') {
            state = state + "]";
        }
        charSequence = MutableCharSequence.getTemporal();
        charSequence.setString(state);
        if (propList.size() == 1) {
            int index;
            AbstractProperty property = (AbstractProperty)propList.get(0);
            String name = property.getName();
            charSequence.setSubstring(propStrStart + name.length() + 2, state.length() - 1);
            int n = index = charSequence.length() <= 0 ? -1 : property.getIndexFor(charSequence);
            if (index != -1) {
                return type.withPropertyId(index);
            }
        }
        int stateId = defaultState != null ? defaultState.getInternalId() : type.getInternalId();
        int length = state.length();
        Property property = null;
        block4: for (int i = last = propStrStart + 1; i < length; ++i) {
            char c = state.charAt(i);
            switch (c) {
                case ',': 
                case ']': {
                    int index;
                    charSequence.setSubstring(last, i);
                    if (property != null) {
                        index = property.getIndexFor(charSequence);
                        if (index == -1) {
                            throw SuggestInputParseException.of(charSequence.toString(), ((AbstractProperty)property).getValues());
                        }
                    } else {
                        PropertyKey key = PropertyKey.get(charSequence);
                        if (key == null || !type.hasProperty(key)) {
                            String input = charSequence.toString();
                            BlockType finalType = type;
                            throw new SuggestInputParseException("Invalid property " + (Object)((Object)key) + ":" + input + " for type " + type, input, () -> finalType.getProperties().stream().map(Property::getName).filter(p -> StringMan.blockStateMatches(input, p)).sorted(StringMan.blockStateComparator(input)).collect(Collectors.toList()));
                        }
                        throw new SuggestInputParseException("No operator for " + state, "", () -> Collections.singletonList("="));
                    }
                    stateId = ((AbstractProperty)property).modifyIndex(stateId, index);
                    property = null;
                    last = i + 1;
                    continue block4;
                }
                case '=': {
                    charSequence.setSubstring(last, i);
                    property = (AbstractProperty)type.getPropertyMap().get(charSequence);
                    last = i + 1;
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return type.withPropertyId(stateId >> BlockTypesCache.BIT_OFFSET);
    }

    @Override
    public BlockState withPropertyId(int propertyId) {
        return this.getBlockType().withPropertyId(propertyId);
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        return set.setBlock(extent, this);
    }

    @Override
    public BaseBlock apply(BlockVector3 position) {
        return this.toBaseBlock();
    }

    public Mask toMask() {
        return new SingleBlockStateMask(new NullExtent(), this);
    }

    @Override
    public void applyTileEntity(OutputExtent output, int x, int y, int z) {
    }

    @Override
    @Deprecated
    public final int getInternalPropertiesId() {
        return this.getInternalId() >> BlockTypesCache.BIT_OFFSET;
    }

    @Override
    @Deprecated
    public final int getInternalBlockTypeId() {
        return this.getInternalId() & BlockTypesCache.BIT_MASK;
    }

    @Override
    public <V> BlockState with(Property<V> property, V value) {
        try {
            BlockType type = this.getBlockType();
            int newState = ((AbstractProperty)property).modify(this.getInternalId(), value);
            return newState != this.getInternalId() ? type.withStateId(newState) : this;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + property);
        }
    }

    @Override
    public <V> V getState(Property<V> property) {
        try {
            AbstractProperty ap = (AbstractProperty)property;
            return (V)ap.getValue(this.getInternalId());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + property);
        }
    }

    @Override
    public <V> BlockState with(PropertyKey property, V value) {
        try {
            BlockType type = this.getBlockType();
            int newState = ((AbstractProperty)type.getProperty(property)).modify(this.getInternalId(), value);
            return newState != this.getInternalId() ? type.withStateId(newState) : this;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property not found: " + (Object)((Object)property));
        }
    }

    public <V> BlockState withProperties(BlockState other) {
        BlockType ot = other.getBlockType();
        if (ot == this.blockType) {
            return other;
        }
        if (ot.getProperties().isEmpty() || this.blockType.getProperties().isEmpty()) {
            return this;
        }
        BlockStateHolder<BlockState> newState = this;
        for (Property<?> prop : ot.getProperties()) {
            PropertyKey key = prop.getKey();
            if (!this.blockType.hasProperty(key)) continue;
            newState = newState.with(key, (Object)other.getState(key));
        }
        return this;
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        BlockType type = this.getBlockType();
        Map map = Maps.asMap(type.getPropertiesSet(), this::getState);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o.getClass() == BlockState.class) {
            return o.getOrdinal() == this.getOrdinal();
        }
        return o.equalsFuzzy(this);
    }

    @Override
    public BlockState toImmutableState() {
        return this;
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this.emptyBaseBlock;
    }

    @Override
    @Deprecated
    public <V> V getState(PropertyKey key) {
        return this.getState(this.getBlockType().getProperty(key));
    }

    @Override
    public BaseBlock toBaseBlock(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return this.toBaseBlock();
        }
        return new BaseBlock(this, compoundTag);
    }

    @Override
    public int getInternalId() {
        return this.internalId;
    }

    @Override
    public BlockMaterial getMaterial() {
        if (this.material == null) {
            if (this.blockType == BlockTypes.__RESERVED__) {
                this.material = this.blockType.getMaterial();
                return this.material;
            }
            this.material = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry().getMaterial(this);
            if (this.material.hasContainer()) {
                this.compoundInput = CompoundInput.CONTAINER;
            }
        }
        return this.material;
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final char getOrdinalChar() {
        return this.ordinalChar;
    }

    public String toString() {
        return this.getAsString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockState)) {
            return false;
        }
        return this.equalsFuzzy((BlockState)obj);
    }

    public int hashCode() {
        return this.getOrdinal();
    }

    public boolean isAir() {
        return this.blockType.getMaterial().isAir();
    }

    @Override
    public BaseBlock toBaseBlock(ITileInput input, int x, int y, int z) {
        return this.compoundInput.get(this, input, x, y, z);
    }
}

