/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.function.mask.SingleBlockTypeMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class BlockType
implements Keyed,
Pattern {
    public static final NamespacedRegistry<BlockType> REGISTRY = new NamespacedRegistry("block type");
    private final String id;
    private final BlockTypesCache.Settings settings;
    private final LazyReference<FuzzyBlockState> emptyFuzzy = LazyReference.from(() -> new FuzzyBlockState(this));
    private final LazyReference<Integer> legacyId = LazyReference.from(() -> this.computeLegacy(0));
    private final LazyReference<Integer> legacyData = LazyReference.from(() -> this.computeLegacy(1));
    private Integer legacyCombinedId;
    private boolean initItemType;
    private ItemType itemType;

    protected BlockType(String id, int internalId, List<BlockState> states) {
        int i = id.indexOf("[");
        this.id = i == -1 ? id : id.substring(0, i);
        this.settings = new BlockTypesCache.Settings(this, id, internalId, states);
    }

    public BlockType(String id, Function<BlockState, BlockState> values) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        this.id = id;
        this.settings = new BlockTypesCache.Settings(this, id, 0, null);
    }

    @Deprecated
    public int getMaxStateId() {
        return this.settings.permutations;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Component getRichName() {
        return WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry().getRichName(this);
    }

    public String getNamespace() {
        String id = this.getId();
        int i = id.indexOf(58);
        return i == -1 ? "minecraft" : id.substring(0, i);
    }

    public String getResource() {
        String id = this.getId();
        return id.substring(id.indexOf(58) + 1);
    }

    @Deprecated
    public String getName() {
        return this.getRichName().toString();
    }

    @Deprecated
    public BlockState withPropertyId(int propertyId) {
        if (this.settings.stateOrdinals == null) {
            return this.settings.defaultState;
        }
        return BlockTypesCache.states[this.settings.stateOrdinals[propertyId]];
    }

    @Deprecated
    public BlockState withStateId(int internalStateId) {
        return this.withPropertyId(internalStateId >> BlockTypesCache.BIT_OFFSET);
    }

    public Map<String, ? extends Property<?>> getPropertyMap() {
        return this.settings.propertiesMap;
    }

    public List<? extends Property<?>> getProperties() {
        return this.settings.propertiesList;
    }

    @Deprecated
    public Set<? extends Property<?>> getPropertiesSet() {
        return this.settings.propertiesSet;
    }

    public <V> Property<V> getProperty(String name) {
        return this.settings.propertiesMap.get(name);
    }

    public boolean hasProperty(PropertyKey key) {
        int ordinal = key.ordinal();
        return this.settings.propertiesMapArr.length > ordinal ? this.settings.propertiesMapArr[ordinal] != null : false;
    }

    public <V> Property<V> getProperty(PropertyKey key) {
        try {
            return this.settings.propertiesMapArr[key.ordinal()];
        }
        catch (IndexOutOfBoundsException ignored) {
            return null;
        }
    }

    public BlockState getDefaultState() {
        return this.settings.defaultState;
    }

    public FuzzyBlockState getFuzzyMatcher() {
        return this.emptyFuzzy.getValue();
    }

    public List<BlockState> getAllStates() {
        if (this.settings.stateOrdinals == null) {
            return Collections.singletonList(this.getDefaultState());
        }
        return IntStream.of(this.settings.stateOrdinals).filter(i -> i != -1).mapToObj(i -> BlockTypesCache.states[i]).collect(Collectors.toList());
    }

    public BlockState getState(Map<Property<?>, Object> key) {
        int id = this.getInternalId();
        for (Map.Entry<Property<?>, Object> iter : key.entrySet()) {
            Property<?> prop = iter.getKey();
            Object value = iter.getValue();
            AbstractProperty<?> btp = this.settings.propertiesMap.get(prop.getName());
            Preconditions.checkArgument((btp != null ? 1 : 0) != 0, (String)"%s has no property named %s", (Object)this, (Object)prop.getName());
            id = btp.modify(id, btp.getValueFor((String)value));
        }
        return this.withStateId(id);
    }

    public boolean hasItemType() {
        return this.getItemType() != null;
    }

    @Nullable
    public ItemType getItemType() {
        if (!this.initItemType) {
            this.initItemType = true;
            this.itemType = ItemTypes.get(this.id);
        }
        return this.itemType;
    }

    public BlockMaterial getMaterial() {
        return this.settings.blockMaterial;
    }

    @Deprecated
    public int getLegacyCombinedId() {
        Integer combinedId = LegacyMapper.getInstance().getLegacyCombined(this);
        return combinedId == null ? 0 : combinedId;
    }

    @Deprecated
    public int getLegacyId() {
        return this.computeLegacy(0);
    }

    @Deprecated
    public int getLegacyData() {
        return this.computeLegacy(1);
    }

    private int computeLegacy(int index) {
        if (this.legacyCombinedId == null) {
            this.legacyCombinedId = LegacyMapper.getInstance().getLegacyCombined(this.getDefaultState());
        }
        return index == 0 ? this.legacyCombinedId >> 4 : this.legacyCombinedId & 0xF;
    }

    public int getInternalId() {
        return this.settings.internalId;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.settings.internalId;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        return set.setBlock(extent, this.getDefaultState());
    }

    @Override
    public BaseBlock apply(BlockVector3 position) {
        return this.getDefaultState().toBaseBlock();
    }

    public SingleBlockTypeMask toMask() {
        return this.toMask(new NullExtent());
    }

    public SingleBlockTypeMask toMask(Extent extent) {
        return new SingleBlockTypeMask(extent, this);
    }
}

