/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.registry.state.PropertyGroup;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;

public class BlockTypeUtil {
    public static double centralTopLimit(BlockType type) {
        Preconditions.checkNotNull((Object)type);
        return BlockTypeUtil.centralTopLimit(type.getDefaultState());
    }

    public static double centralBottomLimit(BlockStateHolder block) {
        Preconditions.checkNotNull((Object)block);
        BlockType type = block.getBlockType();
        switch (type.getInternalId()) {
            case 126: 
            case 189: 
            case 406: 
            case 598: {
                return 0.25;
            }
            case 13: 
            case 37: 
            case 74: 
            case 115: 
            case 152: 
            case 157: 
            case 276: 
            case 349: 
            case 367: 
            case 389: 
            case 436: 
            case 439: 
            case 457: 
            case 461: 
            case 475: 
            case 495: 
            case 523: 
            case 529: 
            case 534: {
                String state = (String)block.getState(PropertyKey.TYPE);
                if (state == null) {
                    return 0.0;
                }
                switch (state) {
                    case "top": {
                        return 0.5;
                    }
                }
                return 0.0;
            }
            case 15: 
            case 39: 
            case 154: 
            case 264: 
            case 278: 
            case 369: 
            case 525: {
                if (block.getState(PropertyKey.OPEN) == Boolean.TRUE) {
                    return 1.0;
                }
                if ("bottom".equals(block.getState(PropertyKey.HALF))) {
                    return 0.8125;
                }
                return 0.0;
            }
            case 7: 
            case 31: 
            case 146: 
            case 270: 
            case 361: 
            case 517: {
                return block.getState(PropertyKey.OPEN) == Boolean.TRUE ? 1.0 : 0.0;
            }
        }
        if (type.getMaterial().isMovementBlocker()) {
            return 0.0;
        }
        return 1.0;
    }

    public static double centralTopLimit(BlockStateHolder block) {
        Preconditions.checkNotNull((Object)block);
        BlockType type = block.getBlockType();
        switch (type.getInternalId()) {
            case 42: 
            case 54: 
            case 78: 
            case 130: 
            case 223: 
            case 235: 
            case 289: 
            case 301: 
            case 316: 
            case 328: 
            case 374: 
            case 391: 
            case 444: 
            case 465: 
            case 571: 
            case 586: {
                return 0.5625;
            }
            case 73: {
                return 0.875;
            }
            case 97: {
                return block.getState(PropertyKey.BITES) == Integer.valueOf(6) ? 0.0 : 0.4375;
            }
            case 100: {
                return 0.3125;
            }
            case 119: {
                return 0.75;
            }
            case 194: {
                return 0.75;
            }
            case 197: {
                return block.getState(PropertyKey.EYE) == Boolean.TRUE ? 1.0 : 0.8125;
            }
            case 125: 
            case 188: 
            case 404: 
            case 405: 
            case 597: {
                return 0.5;
            }
            case 126: 
            case 189: 
            case 406: 
            case 598: {
                return 0.75;
            }
            case 6: 
            case 30: 
            case 145: 
            case 269: 
            case 348: 
            case 360: 
            case 516: {
                return 1.5;
            }
            case 13: 
            case 37: 
            case 74: 
            case 115: 
            case 152: 
            case 157: 
            case 276: 
            case 349: 
            case 367: 
            case 389: 
            case 436: 
            case 439: 
            case 457: 
            case 461: 
            case 475: 
            case 495: 
            case 523: 
            case 529: 
            case 534: {
                String state = (String)block.getState(PropertyKey.TYPE);
                if (state == null) {
                    return 0.5;
                }
                switch (state) {
                    case "bottom": {
                        return 0.5;
                    }
                    case "top": 
                    case "double": {
                        return 1.0;
                    }
                }
            }
            case 314: {
                return 0.015625;
            }
            case 490: {
                return 0.125;
            }
            case 511: {
                return 0.875;
            }
            case 117: 
            case 343: {
                return 1.5;
            }
            case 209: {
                return 0.375;
            }
            case 121: {
                return 0.125;
            }
            case 159: {
                return 0.375;
            }
            case 248: {
                return 0.625;
            }
            case 15: 
            case 39: 
            case 154: 
            case 264: 
            case 278: 
            case 369: 
            case 525: {
                if (block.getState(PropertyKey.OPEN) == Boolean.TRUE) {
                    return 0.0;
                }
                if ("top".equals(block.getState(PropertyKey.HALF))) {
                    return 1.0;
                }
                return 0.1875;
            }
            case 7: 
            case 31: 
            case 146: 
            case 270: 
            case 361: 
            case 517: {
                return block.getState(PropertyKey.OPEN) == Boolean.TRUE ? 0.0 : 1.5;
            }
        }
        if (type.hasProperty(PropertyKey.LAYERS)) {
            return (double)PropertyGroup.LEVEL.get(block).intValue() * 0.0625;
        }
        if (!type.getMaterial().isMovementBlocker()) {
            return 0.0;
        }
        return 1.0;
    }
}

