/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectArrayMap;
import com.sk89q.worldedit.extension.factory.BlockFactory;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class LegacyMapper {
    private static final Logger log = LoggerFactory.getLogger(LegacyMapper.class);
    private static LegacyMapper INSTANCE;
    private final ResourceLoader resourceLoader;
    private final Int2ObjectArrayMap<Integer> blockStateToLegacyId4Data = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<Integer> extraId4DataToStateId = new Int2ObjectArrayMap();
    private final int[] blockArr = new int[4096];
    private final BiMap<Integer, ItemType> itemMap = HashBiMap.create();
    private Map<String, String> blockEntries = new HashMap<String, String>();
    private final Map<String, BlockState> stringToBlockMap = new HashMap<String, BlockState>();
    private final Multimap<BlockState, String> blockToStringMap = HashMultimap.create();
    private final Map<String, ItemType> stringToItemMap = new HashMap<String, ItemType>();
    private final Multimap<ItemType, String> itemToStringMap = HashMultimap.create();

    private LegacyMapper() {
        this.resourceLoader = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.CONFIGURATION).getResourceLoader();
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.warn("Failed to load the built-in legacy id registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Vector3.class, (Object)new VectorAdapter());
        Gson gson = gsonBuilder.disableHtmlEscaping().create();
        URL url = this.resourceLoader.getResource(LegacyMapper.class, "legacy.json");
        if (url == null) {
            throw new IOException("Could not find legacy.json");
        }
        String data = Resources.toString((URL)url, (Charset)Charset.defaultCharset());
        LegacyDataFile dataFile = (LegacyDataFile)gson.fromJson(data, new TypeToken<LegacyDataFile>(){}.getType());
        DataFixer fixer = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataFixer();
        ParserContext parserContext = new ParserContext();
        parserContext.setPreferringWildcard(false);
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        for (Map.Entry blockEntry : dataFile.blocks.entrySet()) {
            String id = (String)blockEntry.getKey();
            Integer combinedId = this.getCombinedId((String)blockEntry.getKey());
            String value = (String)blockEntry.getValue();
            this.blockEntries.put(id, value);
            BlockStateHolder<BlockState> state = null;
            try {
                state = BlockState.get(null, (String)blockEntry.getValue());
                BlockType type = ((BlockState)state).getBlockType();
                if (type.hasProperty(PropertyKey.WATERLOGGED)) {
                    state = ((BlockState)state).with(PropertyKey.WATERLOGGED, (Object)false);
                }
            }
            catch (InputParseException f) {
                BlockFactory blockFactory = WorldEdit.getInstance().getBlockFactory();
                if (fixer != null) {
                    try {
                        String newEntry = fixer.fixUp(DataFixer.FixTypes.BLOCK_STATE, value, 1631);
                        state = ((BaseBlock)blockFactory.parseFromInput(newEntry, parserContext)).toImmutableState();
                    }
                    catch (InputParseException inputParseException) {
                        // empty catch block
                    }
                }
                if (state == null) {
                    try {
                        state = ((BaseBlock)blockFactory.parseFromInput(value, parserContext)).toImmutableState();
                    }
                    catch (InputParseException inputParseException) {
                        // empty catch block
                    }
                }
                if (state == null) {
                    log.debug("Unknown block: " + value);
                }
                this.blockToStringMap.put((Object)state, (Object)id);
                this.stringToBlockMap.put(id, (BlockState)state);
            }
            if (state == null) continue;
            this.blockArr[combinedId.intValue()] = ((BlockState)state).getInternalId();
            this.blockStateToLegacyId4Data.put(((BlockState)state).getInternalId(), combinedId);
            this.blockStateToLegacyId4Data.putIfAbsent(((BlockState)state).getInternalBlockTypeId(), combinedId);
        }
        for (int id = 0; id < 256; ++id) {
            int combinedId = id << 4;
            int base = this.blockArr[combinedId];
            if (base == 0) continue;
            int data_ = 0;
            while (data_ < 16) {
                if (this.blockArr[combinedId] == 0) {
                    this.blockArr[combinedId] = base;
                }
                ++data_;
                ++combinedId;
            }
        }
        for (Map.Entry itemEntry : dataFile.items.entrySet()) {
            String id = (String)itemEntry.getKey();
            String value = (String)itemEntry.getValue();
            ItemType type = ItemTypes.get(value);
            if (type == null && fixer != null) {
                value = fixer.fixUp(DataFixer.FixTypes.ITEM_TYPE, value, 1631);
                type = ItemTypes.get(value);
            }
            if (type == null) {
                log.debug("Unknown item: " + value);
                continue;
            }
            try {
                this.itemMap.put((Object)this.getCombinedId(id), (Object)type);
            }
            catch (Exception exception) {}
        }
    }

    private int getCombinedId(String input) {
        String[] split = input.split(":");
        return (Integer.parseInt(split[0]) << 4) + (split.length == 2 ? Integer.parseInt(split[1]) : 0);
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId) {
        return (ItemType)this.itemMap.get((Object)(legacyId << 4));
    }

    public ItemType getItemFromLegacy(String input) {
        if (input.startsWith("minecraft:")) {
            input = input.substring(10);
        }
        return (ItemType)this.itemMap.get((Object)this.getCombinedId(input));
    }

    public BlockState getBlockFromLegacy(String input) {
        if (input.startsWith("minecraft:")) {
            input = input.substring(10);
        }
        try {
            return BlockState.getFromInternalId(this.blockArr[this.getCombinedId(input)]);
        }
        catch (InputParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId, int data) {
        return (ItemType)this.itemMap.get((Object)((legacyId << 4) + data));
    }

    @Nullable
    public Integer getLegacyCombined(ItemType itemType) {
        return (Integer)this.itemMap.inverse().get((Object)itemType);
    }

    @Nullable
    public int[] getLegacyFromItem(ItemType itemType) {
        Integer combinedId = this.getLegacyCombined(itemType);
        if (combinedId == null) {
            return null;
        }
        return new int[]{combinedId >> 4, combinedId & 0xF};
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId) {
        return this.getBlock(legacyId << 4);
    }

    @Nullable
    public BlockState getBlockFromLegacyCombinedId(int combinedId) {
        return this.getBlock(combinedId);
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId, int data) {
        return this.getBlock((legacyId << 4) + data);
    }

    private BlockState getBlock(int combinedId) {
        Integer extra;
        if (combinedId < this.blockArr.length) {
            try {
                int internalId = this.blockArr[combinedId];
                if (internalId == 0) {
                    return null;
                }
                try {
                    return BlockState.getFromInternalId(internalId);
                }
                catch (InputParseException e) {
                    e.printStackTrace();
                }
            }
            catch (IndexOutOfBoundsException ignored) {
                return null;
            }
        }
        if ((extra = this.extraId4DataToStateId.get(combinedId)) == null) {
            extra = this.extraId4DataToStateId.get(combinedId & 0xFF0);
        }
        if (extra != null) {
            try {
                return BlockState.getFromInternalId(extra);
            }
            catch (InputParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void register(int id, int data, BlockStateHolder state) {
        Integer combinedId = (id << 4) + data;
        this.extraId4DataToStateId.put(combinedId, (Integer)state.getInternalId());
        this.blockStateToLegacyId4Data.putIfAbsent(state.getInternalId(), combinedId);
    }

    @Nullable
    public Integer getLegacyCombined(BlockState blockState) {
        Integer result = this.blockStateToLegacyId4Data.get(blockState.getInternalId());
        if (result == null) {
            result = this.blockStateToLegacyId4Data.get(blockState.getInternalBlockTypeId());
        }
        return result;
    }

    @Nullable
    public Integer getLegacyCombined(BlockType type) {
        return this.blockStateToLegacyId4Data.get(type.getDefaultState().getInternalId());
    }

    @Deprecated
    public int[] getLegacyFromBlock(BlockState blockState) {
        int[] nArray;
        Integer combinedId = this.getLegacyCombined(blockState);
        if (combinedId == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = combinedId >> 4;
            nArray = nArray2;
            nArray2[1] = combinedId & 0xF;
        }
        return nArray;
    }

    public static LegacyMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyMapper();
        }
        return INSTANCE;
    }

    private static class LegacyDataFile {
        private Map<String, String> blocks;
        private Map<String, String> items;

        private LegacyDataFile() {
        }
    }
}

