/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_14_R1;

import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.v1_14_R1.PlayerDataManager;
import java.lang.reflect.Field;
import net.minecraft.server.v1_14_R1.BlockBarrel;
import net.minecraft.server.v1_14_R1.BlockChest;
import net.minecraft.server.v1_14_R1.BlockChestTrapped;
import net.minecraft.server.v1_14_R1.BlockEnderChest;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.BlockPropertyChestType;
import net.minecraft.server.v1_14_R1.BlockShulkerBox;
import net.minecraft.server.v1_14_R1.ChatMessage;
import net.minecraft.server.v1_14_R1.Container;
import net.minecraft.server.v1_14_R1.ContainerChest;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumChatFormat;
import net.minecraft.server.v1_14_R1.EnumGamemode;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IBlockState;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.ITileInventory;
import net.minecraft.server.v1_14_R1.InventoryEnderChest;
import net.minecraft.server.v1_14_R1.InventoryLargeChest;
import net.minecraft.server.v1_14_R1.PlayerInteractManager;
import net.minecraft.server.v1_14_R1.PlayerInventory;
import net.minecraft.server.v1_14_R1.TileEntity;
import net.minecraft.server.v1_14_R1.TileEntityChest;
import net.minecraft.server.v1_14_R1.TileEntityEnderChest;
import net.minecraft.server.v1_14_R1.TileEntityLootable;
import net.minecraft.server.v1_14_R1.TileInventory;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.EnderChest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class AnySilentContainer
implements IAnySilentContainer {
    private Field playerInteractManagerGamemode;

    public AnySilentContainer() {
        try {
            this.playerInteractManagerGamemode = PlayerInteractManager.class.getDeclaredField("gamemode");
            this.playerInteractManagerGamemode.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            System.err.println("[OpenInv] Unable to directly write player gamemode! SilentChest will fail.");
            e.printStackTrace();
        }
    }

    @Override
    public boolean isAnySilentContainer(@NotNull Block bukkitBlock) {
        if (bukkitBlock.getType() == Material.ENDER_CHEST) {
            return true;
        }
        BlockState state = bukkitBlock.getState();
        return state instanceof org.bukkit.block.Chest || state instanceof ShulkerBox || state instanceof Barrel;
    }

    @Override
    public boolean isAnyContainerNeeded(@NotNull Player p, @NotNull Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Barrel) {
            return false;
        }
        if (blockState instanceof EnderChest) {
            return block.getRelative(0, 1, 0).getType().isOccluding();
        }
        if (blockState instanceof ShulkerBox) {
            BoundingBox boundingBox = block.getBoundingBox();
            if (boundingBox.getVolume() > 1.0) {
                return false;
            }
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Directional)) {
                return true;
            }
            Directional directional = (Directional)blockData;
            BlockFace face = directional.getFacing();
            boundingBox.shift(face.getDirection());
            return block.getRelative(face, 1).getBoundingBox().overlaps(boundingBox);
        }
        if (!(blockState instanceof org.bukkit.block.Chest)) {
            return false;
        }
        if (this.isBlockedChest(block)) {
            return true;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest) || ((Chest)blockData).getType() == Chest.Type.SINGLE) {
            return false;
        }
        Chest chest = (Chest)blockData;
        int ordinal = (chest.getFacing().ordinal() + 4 + (chest.getType() == Chest.Type.RIGHT ? -1 : 1)) % 4;
        BlockFace relativeFace = BlockFace.values()[ordinal];
        Block relative = block.getRelative(relativeFace);
        if (relative.getType() != block.getType()) {
            return false;
        }
        BlockData relativeData = relative.getBlockData();
        if (!(relativeData instanceof Chest)) {
            return false;
        }
        Chest relativeChest = (Chest)relativeData;
        if (relativeChest.getFacing() != chest.getFacing() || relativeChest.getType() != (chest.getType() == Chest.Type.RIGHT ? Chest.Type.LEFT : Chest.Type.RIGHT)) {
            return false;
        }
        return this.isBlockedChest(relative);
    }

    private boolean isBlockedChest(Block block) {
        Block relative = block.getRelative(0, 1, 0);
        return relative.getType().isOccluding() || block.getWorld().getNearbyEntities(BoundingBox.of((Block)relative), entity -> entity instanceof Cat).size() > 0;
    }

    @Override
    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull Block bukkitBlock) {
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        EntityPlayer player = PlayerDataManager.getHandle(bukkitPlayer);
        World world = player.world;
        BlockPosition blockPosition = new BlockPosition(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ());
        TileEntity tile = world.getTileEntity(blockPosition);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityEnderChest) {
            InventoryEnderChest enderChest = player.getEnderChest();
            enderChest.a((TileEntityEnderChest)tile);
            player.openContainer((ITileInventory)new TileInventory((containerCounter, playerInventory, ignored) -> ContainerChest.a((int)containerCounter, (PlayerInventory)playerInventory, (IInventory)enderChest), (IChatBaseComponent)BlockEnderChest.d));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(tile instanceof ITileInventory)) {
            return false;
        }
        ITileInventory tileInventory = (ITileInventory)tile;
        IBlockData blockData = world.getType(blockPosition);
        net.minecraft.server.v1_14_R1.Block block = blockData.getBlock();
        if (block instanceof BlockChest) {
            TileEntity adjacentTile;
            BlockPropertyChestType adjacentChestType;
            BlockPosition adjacentBlockPosition;
            IBlockData adjacentBlockData;
            BlockPropertyChestType chestType = (BlockPropertyChestType)blockData.get((IBlockState)BlockChest.b);
            if (chestType != BlockPropertyChestType.SINGLE && (adjacentBlockData = world.getType(adjacentBlockPosition = blockPosition.shift(BlockChest.j((IBlockData)blockData)))).getBlock() == block && (adjacentChestType = (BlockPropertyChestType)adjacentBlockData.get((IBlockState)BlockChest.b)) != BlockPropertyChestType.SINGLE && chestType != adjacentChestType && adjacentBlockData.get((IBlockState)BlockChest.FACING) == blockData.get((IBlockState)BlockChest.FACING) && (adjacentTile = world.getTileEntity(adjacentBlockPosition)) instanceof TileEntityChest && tileInventory instanceof TileEntityChest) {
                TileEntityChest leftChest;
                final TileEntityChest rightChest = chestType == BlockPropertyChestType.RIGHT ? (TileEntityChest)tileInventory : (TileEntityChest)adjacentTile;
                TileEntityChest tileEntityChest = leftChest = chestType == BlockPropertyChestType.RIGHT ? (TileEntityChest)adjacentTile : (TileEntityChest)tileInventory;
                if (rightChest.lootTable != null || leftChest.lootTable != null) {
                    player.a(new ChatMessage("Loot not generated! Please disable /silentcontainer.", new Object[0]).a(EnumChatFormat.RED), true);
                    return false;
                }
                tileInventory = new ITileInventory(){

                    public Container createMenu(int containerCounter, PlayerInventory playerInventory, EntityHuman entityHuman) {
                        leftChest.d(playerInventory.player);
                        rightChest.d(playerInventory.player);
                        return ContainerChest.b((int)containerCounter, (PlayerInventory)playerInventory, (IInventory)new InventoryLargeChest((IInventory)rightChest, (IInventory)leftChest));
                    }

                    public IChatBaseComponent getScoreboardDisplayName() {
                        return new ChatMessage("container.chestDouble", new Object[0]);
                    }
                };
            }
            if (block instanceof BlockChestTrapped) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof BlockShulkerBox) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof BlockBarrel) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.playerInteractManager.getGameMode() == EnumGamemode.SPECTATOR) {
            player.openContainer(tileInventory);
            return true;
        }
        if (this.playerInteractManagerGamemode == null) {
            return false;
        }
        if (tile instanceof TileEntityLootable) {
            TileEntityLootable lootable = (TileEntityLootable)tile;
            if (lootable.lootTable != null) {
                player.a(new ChatMessage("Loot not generated! Please disable /silentcontainer.", new Object[0]).a(EnumChatFormat.RED), true);
                return false;
            }
        }
        EnumGamemode gamemode = player.playerInteractManager.getGameMode();
        this.forceGameMode(player, EnumGamemode.SPECTATOR);
        player.openContainer(tileInventory);
        this.forceGameMode(player, gamemode);
        return true;
    }

    @Override
    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.playerInteractManagerGamemode == null) {
            return;
        }
        InventoryView view = bukkitPlayer.getOpenInventory();
        switch (view.getType()) {
            case CHEST: 
            case ENDER_CHEST: 
            case SHULKER_BOX: 
            case BARREL: {
                break;
            }
            default: {
                return;
            }
        }
        EntityPlayer player = PlayerDataManager.getHandle(bukkitPlayer);
        EnumGamemode gamemode = player.playerInteractManager.getGameMode();
        this.forceGameMode(player, EnumGamemode.SPECTATOR);
        player.activeContainer.b((EntityHuman)player);
        player.activeContainer = player.defaultContainer;
        this.forceGameMode(player, gamemode);
    }

    private void forceGameMode(EntityPlayer player, EnumGamemode gameMode) {
        if (this.playerInteractManagerGamemode == null) {
            return;
        }
        try {
            if (!this.playerInteractManagerGamemode.isAccessible()) {
                this.playerInteractManagerGamemode.setAccessible(true);
            }
            this.playerInteractManagerGamemode.set(player.playerInteractManager, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

