/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_14_R1;

import com.lishid.openinv.internal.IPlayerDataManager;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.v1_14_R1.SpecialEnderChest;
import com.lishid.openinv.internal.v1_14_R1.SpecialPlayerInventory;
import com.mojang.authlib.GameProfile;
import net.minecraft.server.v1_14_R1.ChatComponentText;
import net.minecraft.server.v1_14_R1.Container;
import net.minecraft.server.v1_14_R1.Containers;
import net.minecraft.server.v1_14_R1.DedicatedServer;
import net.minecraft.server.v1_14_R1.DimensionManager;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.ICrafting;
import net.minecraft.server.v1_14_R1.MinecraftServer;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_14_R1.PlayerInteractManager;
import net.minecraft.server.v1_14_R1.PlayerInventory;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftContainer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public class PlayerDataManager
implements IPlayerDataManager {
    public static EntityPlayer getHandle(Player player) {
        if (player instanceof CraftPlayer) {
            return ((CraftPlayer)player).getHandle();
        }
        Server server = player.getServer();
        EntityPlayer nmsPlayer = null;
        if (server instanceof CraftServer) {
            nmsPlayer = ((CraftServer)server).getHandle().getPlayer(player.getName());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from provided Player implementation");
        }
        return nmsPlayer;
    }

    @Override
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName());
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer((MinecraftServer)server, server.getWorldServer(DimensionManager.OVERWORLD), profile, new PlayerInteractManager(server.getWorldServer(DimensionManager.OVERWORLD)));
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }

    @Override
    public InventoryView openInventory(final @NotNull Player player, final @NotNull ISpecialInventory inventory) {
        String title;
        HumanEntity owner;
        EntityPlayer nmsPlayer = PlayerDataManager.getHandle(player);
        if (nmsPlayer == null || nmsPlayer.playerConnection == null) {
            return null;
        }
        if (inventory instanceof SpecialEnderChest) {
            owner = (HumanEntity)((SpecialEnderChest)inventory).getBukkitOwner();
            title = (owner.getName() != null ? owner.getName() : owner.getUniqueId().toString()) + "'s Ender Chest";
        } else if (inventory instanceof SpecialPlayerInventory) {
            owner = ((PlayerInventory)inventory).player;
            title = (owner.getName() != null ? owner.getName() : owner.getUniqueID().toString()) + "'s Inventory";
        } else {
            return player.openInventory(inventory.getBukkitInventory());
        }
        CraftContainer container = new CraftContainer(new InventoryView(){

            @NotNull
            public Inventory getTopInventory() {
                return inventory.getBukkitInventory();
            }

            @NotNull
            public Inventory getBottomInventory() {
                return player.getInventory();
            }

            @NotNull
            public HumanEntity getPlayer() {
                return player;
            }

            @NotNull
            public InventoryType getType() {
                return inventory.getBukkitInventory().getType();
            }

            @NotNull
            public String getTitle() {
                return title;
            }
        }, (EntityHuman)nmsPlayer, nmsPlayer.nextContainerCounter()){

            public Containers<?> getType() {
                switch (inventory.getBukkitInventory().getSize()) {
                    case 9: {
                        return Containers.GENERIC_9X1;
                    }
                    case 18: {
                        return Containers.GENERIC_9X2;
                    }
                    default: {
                        return Containers.GENERIC_9X3;
                    }
                    case 36: {
                        return Containers.GENERIC_9X4;
                    }
                    case 41: 
                    case 45: {
                        return Containers.GENERIC_9X5;
                    }
                    case 54: 
                }
                return Containers.GENERIC_9X6;
            }
        };
        container.setTitle((IChatBaseComponent)new ChatComponentText(title));
        container = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)nmsPlayer, (Container)container);
        if (container == null) {
            return null;
        }
        nmsPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, container.getType(), (IChatBaseComponent)new ChatComponentText(container.getBukkitView().getTitle())));
        nmsPlayer.activeContainer = container;
        container.addSlotListener((ICrafting)nmsPlayer);
        return container.getBukkitView();
    }
}

