/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_14_R1;

import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.v1_14_R1.PlayerDataManager;
import java.util.List;
import net.minecraft.server.v1_14_R1.AutoRecipeStackManager;
import net.minecraft.server.v1_14_R1.ContainerUtil;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.IInventoryListener;
import net.minecraft.server.v1_14_R1.InventoryEnderChest;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.NonNullList;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class SpecialEnderChest
extends InventoryEnderChest
implements ISpecialEnderChest {
    private final CraftInventory inventory = new CraftInventory((IInventory)this);
    private EntityPlayer owner;
    private NonNullList<ItemStack> items;
    private boolean playerOnline;

    public SpecialEnderChest(Player player, Boolean online) {
        super((EntityHuman)PlayerDataManager.getHandle(player));
        this.owner = PlayerDataManager.getHandle(player);
        this.playerOnline = online;
        this.items = this.owner.getEnderChest().items;
    }

    @NotNull
    public CraftInventory getBukkitInventory() {
        return this.inventory;
    }

    @Override
    public boolean isInUse() {
        return !this.getViewers().isEmpty();
    }

    @Override
    public void setPlayerOffline() {
        this.playerOnline = false;
    }

    @Override
    public void setPlayerOnline(@NotNull Player player) {
        if (!this.playerOnline) {
            try {
                this.owner = PlayerDataManager.getHandle(player);
                InventoryEnderChest enderChest = this.owner.getEnderChest();
                for (int i = 0; i < enderChest.getSize(); ++i) {
                    enderChest.setItem(i, (ItemStack)this.items.get(i));
                }
                this.items = enderChest.items;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.playerOnline = true;
        }
    }

    public void update() {
        this.owner.getEnderChest().update();
    }

    public List<ItemStack> getContents() {
        return this.items;
    }

    public void onOpen(CraftHumanEntity who) {
        this.owner.getEnderChest().onOpen(who);
    }

    public void onClose(CraftHumanEntity who) {
        this.owner.getEnderChest().onClose(who);
    }

    public List<HumanEntity> getViewers() {
        return this.owner.getEnderChest().getViewers();
    }

    public void setMaxStackSize(int i) {
        this.owner.getEnderChest().setMaxStackSize(i);
    }

    public InventoryHolder getOwner() {
        return this.owner.getEnderChest().getOwner();
    }

    public Location getLocation() {
        return null;
    }

    public void a(IInventoryListener iinventorylistener) {
        this.owner.getEnderChest().a(iinventorylistener);
    }

    public void b(IInventoryListener iinventorylistener) {
        this.owner.getEnderChest().b(iinventorylistener);
    }

    public ItemStack getItem(int i) {
        return i >= 0 && i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.a;
    }

    public ItemStack splitStack(int i, int j) {
        ItemStack itemstack = ContainerUtil.a(this.items, (int)i, (int)j);
        if (!itemstack.isEmpty()) {
            this.update();
        }
        return itemstack;
    }

    public ItemStack a(ItemStack itemstack) {
        ItemStack itemstack1 = itemstack.cloneItemStack();
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack itemstack2 = this.getItem(i);
            if (itemstack2.isEmpty()) {
                this.setItem(i, itemstack1);
                this.update();
                return ItemStack.a;
            }
            if (!ItemStack.c((ItemStack)itemstack2, (ItemStack)itemstack1)) continue;
            int j = Math.min(this.getMaxStackSize(), itemstack2.getMaxStackSize());
            int k = Math.min(itemstack1.getCount(), j - itemstack2.getCount());
            if (k <= 0) continue;
            itemstack2.add(k);
            itemstack1.subtract(k);
            if (!itemstack1.isEmpty()) continue;
            this.update();
            return ItemStack.a;
        }
        if (itemstack1.getCount() != itemstack.getCount()) {
            this.update();
        }
        return itemstack1;
    }

    public ItemStack splitWithoutUpdate(int i) {
        ItemStack itemstack = (ItemStack)this.items.get(i);
        if (itemstack.isEmpty()) {
            return ItemStack.a;
        }
        this.items.set(i, (Object)ItemStack.a);
        return itemstack;
    }

    public void setItem(int i, ItemStack itemstack) {
        this.items.set(i, (Object)itemstack);
        if (!itemstack.isEmpty() && itemstack.getCount() > this.getMaxStackSize()) {
            itemstack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public int getSize() {
        return this.owner.getEnderChest().getSize();
    }

    public boolean isNotEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean a(EntityHuman entityhuman) {
        return true;
    }

    public void startOpen(EntityHuman entityhuman) {
    }

    public void closeContainer(EntityHuman entityhuman) {
    }

    public boolean b(int i, ItemStack itemstack) {
        return true;
    }

    public void clear() {
        this.items.clear();
    }

    public void a(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.b(itemstack);
        }
    }
}

