/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_14_R1;

import com.google.common.collect.ImmutableList;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.v1_14_R1.PlayerDataManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.v1_14_R1.AutoRecipeStackManager;
import net.minecraft.server.v1_14_R1.ChatMessage;
import net.minecraft.server.v1_14_R1.ContainerUtil;
import net.minecraft.server.v1_14_R1.CrashReport;
import net.minecraft.server.v1_14_R1.CrashReportSystemDetails;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumItemSlot;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.IMaterial;
import net.minecraft.server.v1_14_R1.Item;
import net.minecraft.server.v1_14_R1.ItemArmor;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NBTTagList;
import net.minecraft.server.v1_14_R1.NonNullList;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_14_R1.PlayerInventory;
import net.minecraft.server.v1_14_R1.ReportedException;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialPlayerInventory
extends PlayerInventory
implements ISpecialPlayerInventory {
    private final CraftInventory inventory = new CraftInventory((IInventory)this);
    private boolean playerOnline;
    private EntityHuman player;
    private NonNullList<ItemStack> items;
    private NonNullList<ItemStack> armor;
    private NonNullList<ItemStack> extraSlots;
    private List<NonNullList<ItemStack>> f;

    public SpecialPlayerInventory(Player bukkitPlayer, Boolean online) {
        super((EntityHuman)PlayerDataManager.getHandle(bukkitPlayer));
        this.playerOnline = online;
        this.player = ((PlayerInventory)this).player;
        this.items = this.player.inventory.items;
        this.armor = this.player.inventory.armor;
        this.extraSlots = this.player.inventory.extraSlots;
        this.f = ImmutableList.of(this.items, this.armor, this.extraSlots);
    }

    @Override
    public void setPlayerOnline(@NotNull Player player) {
        if (!this.playerOnline) {
            EntityPlayer entityPlayer = PlayerDataManager.getHandle(player);
            entityPlayer.inventory.transaction.addAll(this.transaction);
            this.player = entityPlayer;
            for (int i = 0; i < this.getSize(); ++i) {
                this.player.inventory.setItem(i, this.getRawItem(i));
            }
            this.player.inventory.itemInHandIndex = this.itemInHandIndex;
            this.items = this.player.inventory.items;
            this.armor = this.player.inventory.armor;
            this.extraSlots = this.player.inventory.extraSlots;
            this.f = ImmutableList.of(this.items, this.armor, this.extraSlots);
            this.playerOnline = true;
        }
    }

    public boolean a(EntityHuman entityhuman) {
        return true;
    }

    @NotNull
    public CraftInventory getBukkitInventory() {
        return this.inventory;
    }

    public ItemStack getItem(int i) {
        NonNullList<ItemStack> list = this.items;
        if (i >= list.size()) {
            i -= list.size();
            list = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= list.size()) {
            i -= list.size();
            list = this.extraSlots;
        } else if (list == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (i >= list.size()) {
            return ItemStack.a;
        }
        return (ItemStack)list.get(i);
    }

    private ItemStack getRawItem(int i) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> next : this.f) {
            if (i < next.size()) {
                list = next;
                break;
            }
            i -= next.size();
        }
        return list == null ? ItemStack.a : (ItemStack)list.get(i);
    }

    public IChatBaseComponent getDisplayName() {
        return new ChatMessage(this.player.getName(), new Object[0]);
    }

    public boolean hasCustomName() {
        return false;
    }

    private int getReversedArmorSlotNum(int i) {
        if (i == 0) {
            return 3;
        }
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 0;
        }
        return i;
    }

    private int getReversedItemSlotNum(int i) {
        if (i >= 27) {
            return i - 27;
        }
        return i + 9;
    }

    public int getSize() {
        return 45;
    }

    @Override
    public boolean isInUse() {
        return !this.getViewers().isEmpty();
    }

    public void setItem(int i, ItemStack itemstack) {
        NonNullList<ItemStack> list = this.items;
        if (i >= list.size()) {
            i -= list.size();
            list = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= list.size()) {
            i -= list.size();
            list = this.extraSlots;
        } else if (list == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (i >= list.size()) {
            this.player.drop(itemstack, true);
            return;
        }
        list.set(i, itemstack);
    }

    @Override
    public void setPlayerOffline() {
        this.playerOnline = false;
    }

    public ItemStack splitStack(int i, int j) {
        NonNullList<ItemStack> list = this.items;
        if (i >= list.size()) {
            i -= list.size();
            list = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= list.size()) {
            i -= list.size();
            list = this.extraSlots;
        } else if (list == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (i >= list.size()) {
            return ItemStack.a;
        }
        return ((ItemStack)list.get(i)).isEmpty() ? ItemStack.a : ContainerUtil.a(list, (int)i, (int)j);
    }

    public ItemStack splitWithoutUpdate(int i) {
        NonNullList<ItemStack> list = this.items;
        if (i >= list.size()) {
            i -= list.size();
            list = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= list.size()) {
            i -= list.size();
            list = this.extraSlots;
        } else if (list == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (i >= list.size()) {
            return ItemStack.a;
        }
        if (!((ItemStack)list.get(i)).isEmpty()) {
            ItemStack itemstack = (ItemStack)list.get(i);
            list.set(i, ItemStack.a);
            return itemstack;
        }
        return ItemStack.a;
    }

    public List<ItemStack> getContents() {
        return this.f.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ItemStack> getArmorContents() {
        return this.armor;
    }

    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public ItemStack getItemInHand() {
        return SpecialPlayerInventory.d((int)this.itemInHandIndex) ? (ItemStack)this.items.get(this.itemInHandIndex) : ItemStack.a;
    }

    private boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.isEmpty() && this.b(itemstack, itemstack1) && itemstack.isStackable() && itemstack.getCount() < itemstack.getMaxStackSize() && itemstack.getCount() < this.getMaxStackSize();
    }

    private boolean b(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.getItem() == itemstack1.getItem() && ItemStack.equals((ItemStack)itemstack, (ItemStack)itemstack1);
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.getCount();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = this.getItem(i);
            if (itemstack1.isEmpty()) {
                return itemstack.getCount();
            }
            if (!this.a(itemstack, itemstack1)) {
                remains -= (itemstack1.getMaxStackSize() < this.getMaxStackSize() ? itemstack1.getMaxStackSize() : this.getMaxStackSize()) - itemstack1.getCount();
            }
            if (remains > 0) continue;
            return itemstack.getCount();
        }
        return itemstack.getCount() - remains;
    }

    public int getFirstEmptySlotIndex() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void c(int i) {
        this.itemInHandIndex = this.i();
        ItemStack itemstack = (ItemStack)this.items.get(this.itemInHandIndex);
        this.items.set(this.itemInHandIndex, this.items.get(i));
        this.items.set(i, (Object)itemstack);
    }

    public int c(ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = (ItemStack)this.items.get(i);
            if (((ItemStack)this.items.get(i)).isEmpty() || !this.b(itemstack, (ItemStack)this.items.get(i)) || ((ItemStack)this.items.get(i)).f() || itemstack1.hasEnchantments() || itemstack1.hasName()) continue;
            return i;
        }
        return -1;
    }

    public int i() {
        int i;
        int j;
        for (j = 0; j < 9; ++j) {
            i = (this.itemInHandIndex + j) % 9;
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            return i;
        }
        for (j = 0; j < 9; ++j) {
            i = (this.itemInHandIndex + j) % 9;
            if (((ItemStack)this.items.get(i)).hasEnchantments()) continue;
            return i;
        }
        return this.itemInHandIndex;
    }

    public int a(Predicate<ItemStack> predicate, int i) {
        int k;
        int j = 0;
        for (k = 0; k < this.getSize(); ++k) {
            ItemStack itemstack = this.getItem(k);
            if (itemstack.isEmpty() || !predicate.test(itemstack)) continue;
            int l = i <= 0 ? itemstack.getCount() : Math.min(i - j, itemstack.getCount());
            j += l;
            if (i == 0) continue;
            itemstack.subtract(l);
            if (itemstack.isEmpty()) {
                this.setItem(k, ItemStack.a);
            }
            if (i <= 0 || j < i) continue;
            return j;
        }
        if (!this.getCarried().isEmpty() && predicate.test(this.getCarried())) {
            k = i <= 0 ? this.getCarried().getCount() : Math.min(i - j, this.getCarried().getCount());
            j += k;
            if (i != 0) {
                this.getCarried().subtract(k);
                if (this.getCarried().isEmpty()) {
                    this.setCarried(ItemStack.a);
                }
                if (i > 0 && j >= i) {
                    return j;
                }
            }
        }
        return j;
    }

    private int i(ItemStack itemstack) {
        int i = this.firstPartial(itemstack);
        if (i == -1) {
            i = this.getFirstEmptySlotIndex();
        }
        return i == -1 ? itemstack.getCount() : this.d(i, itemstack);
    }

    private int d(int i, ItemStack itemstack) {
        Item item = itemstack.getItem();
        int j = itemstack.getCount();
        ItemStack itemstack1 = this.getItem(i);
        if (itemstack1.isEmpty()) {
            itemstack1 = new ItemStack((IMaterial)item, 0);
            if (itemstack.hasTag()) {
                itemstack1.setTag(itemstack.getTag().clone());
            }
            this.setItem(i, itemstack1);
        }
        int k = j;
        if (j > itemstack1.getMaxStackSize() - itemstack1.getCount()) {
            k = itemstack1.getMaxStackSize() - itemstack1.getCount();
        }
        if (k > this.getMaxStackSize() - itemstack1.getCount()) {
            k = this.getMaxStackSize() - itemstack1.getCount();
        }
        if (k == 0) {
            return j;
        }
        itemstack1.add(k);
        itemstack1.d(5);
        return j -= k;
    }

    public int firstPartial(ItemStack itemstack) {
        if (this.a(this.getItem(this.itemInHandIndex), itemstack)) {
            return this.itemInHandIndex;
        }
        if (this.a(this.getItem(40), itemstack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.a((ItemStack)this.items.get(i), itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void j() {
        for (List list : this.f) {
            for (int i = 0; i < list.size(); ++i) {
                if (((ItemStack)list.get(i)).isEmpty()) continue;
                ((ItemStack)list.get(i)).a(this.player.world, (Entity)this.player, i, this.itemInHandIndex == i);
            }
        }
    }

    public boolean pickup(ItemStack itemstack) {
        return this.c(-1, itemstack);
    }

    public boolean c(int i, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return false;
        }
        try {
            int j;
            if (itemstack.f()) {
                if (i == -1) {
                    i = this.getFirstEmptySlotIndex();
                }
                if (i >= 0) {
                    this.items.set(i, (Object)itemstack.cloneItemStack());
                    ((ItemStack)this.items.get(i)).d(5);
                    itemstack.setCount(0);
                    return true;
                }
                if (this.player.abilities.canInstantlyBuild) {
                    itemstack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                j = itemstack.getCount();
                if (i == -1) {
                    itemstack.setCount(this.i(itemstack));
                    continue;
                }
                itemstack.setCount(this.d(i, itemstack));
            } while (!itemstack.isEmpty() && itemstack.getCount() < j);
            if (itemstack.getCount() == j && this.player.abilities.canInstantlyBuild) {
                itemstack.setCount(0);
                return true;
            }
            return itemstack.getCount() < j;
        }
        catch (Throwable var6) {
            CrashReport crashreport = CrashReport.a((Throwable)var6, (String)"Adding item to inventory");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Item being added");
            crashreportsystemdetails.a("Item ID", (Object)Item.getId((Item)itemstack.getItem()));
            crashreportsystemdetails.a("Item data", (Object)itemstack.getDamage());
            crashreportsystemdetails.a("Item name", () -> itemstack.getName().getString());
            throw new ReportedException(crashreport);
        }
    }

    public void a(World world, ItemStack itemstack) {
        if (!world.isClientSide) {
            while (!itemstack.isEmpty()) {
                int i = this.firstPartial(itemstack);
                if (i == -1) {
                    i = this.getFirstEmptySlotIndex();
                }
                if (i == -1) {
                    this.player.drop(itemstack, false);
                    break;
                }
                int j = itemstack.getMaxStackSize() - this.getItem(i).getCount();
                if (!this.c(i, itemstack.cloneAndSubtract(j))) continue;
                ((EntityPlayer)this.player).playerConnection.sendPacket((Packet)new PacketPlayOutSetSlot(-2, i, this.getItem(i)));
            }
        }
    }

    public void f(ItemStack itemstack) {
        block0: for (List list : this.f) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != itemstack) continue;
                list.set(i, ItemStack.a);
                continue block0;
            }
        }
    }

    public float a(IBlockData iblockdata) {
        return ((ItemStack)this.items.get(this.itemInHandIndex)).a(iblockdata);
    }

    public NBTTagList a(NBTTagList nbttaglist) {
        NBTTagCompound nbttagcompound;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).save(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        for (i = 0; i < this.armor.size(); ++i) {
            if (((ItemStack)this.armor.get(i)).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)(i + 100));
            ((ItemStack)this.armor.get(i)).save(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        for (i = 0; i < this.extraSlots.size(); ++i) {
            if (((ItemStack)this.extraSlots.get(i)).isEmpty()) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)(i + 150));
            ((ItemStack)this.extraSlots.get(i)).save(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public void b(NBTTagList nbttaglist) {
        this.items.clear();
        this.armor.clear();
        this.extraSlots.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompound(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.a((NBTTagCompound)nbttagcompound);
            if (itemstack.isEmpty()) continue;
            if (j < this.items.size()) {
                this.items.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.extraSlots.size() + 150) continue;
            this.extraSlots.set(j - 150, (Object)itemstack);
        }
    }

    public boolean isNotEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack : this.armor) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack : this.extraSlots) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public IChatBaseComponent getCustomName() {
        return null;
    }

    public boolean b(IBlockData iblockdata) {
        return this.getItem(this.itemInHandIndex).b(iblockdata);
    }

    public void a(float f) {
        if (f > 0.0f) {
            if ((f /= 4.0f) < 1.0f) {
                f = 1.0f;
            }
            for (int i = 0; i < this.armor.size(); ++i) {
                ItemStack itemstack = (ItemStack)this.armor.get(0);
                int index = i;
                if (!(itemstack.getItem() instanceof ItemArmor)) continue;
                itemstack.damage((int)f, (EntityLiving)this.player, entityhuman -> entityhuman.c(EnumItemSlot.a((EnumItemSlot.Function)EnumItemSlot.Function.ARMOR, (int)index)));
            }
        }
    }

    public void dropContents() {
        for (List list : this.f) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.isEmpty()) continue;
                list.set(i, ItemStack.a);
                this.player.a(itemstack, true, false);
            }
        }
    }

    public boolean h(ItemStack itemstack) {
        return this.f.stream().flatMap(Collection::stream).anyMatch(itemStack1 -> !itemStack1.isEmpty() && itemStack1.doMaterialsMatch(itemstack));
    }

    public void a(PlayerInventory playerinventory) {
        for (int i = 0; i < playerinventory.getSize(); ++i) {
            this.setItem(i, playerinventory.getItem(i));
        }
        this.itemInHandIndex = playerinventory.itemInHandIndex;
    }

    public void clear() {
        this.f.forEach(List::clear);
    }

    public void a(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.a(itemstack);
        }
    }
}

