/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ContainerSettingCommand
implements TabExecutor {
    private final OpenInv plugin;

    public ContainerSettingCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        BiConsumer<OfflinePlayer, Boolean> setSetting;
        Predicate<Player> getSetting;
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, "messages.error.consoleUnsupported");
            return true;
        }
        Player player = (Player)sender;
        boolean any = command.getName().startsWith("any");
        Predicate<Player> predicate = any ? this.plugin::getAnyContainerStatus : (getSetting = this.plugin::getSilentContainerStatus);
        BiConsumer<OfflinePlayer, Boolean> biConsumer = any ? this.plugin::setAnyContainerStatus : (setSetting = this.plugin::setSilentContainerStatus);
        if (args.length > 0) {
            args[0] = args[0].toLowerCase();
            if (args[0].equals("on")) {
                setSetting.accept((OfflinePlayer)player, true);
            } else if (args[0].equals("off")) {
                setSetting.accept((OfflinePlayer)player, false);
            } else if (!args[0].equals("check")) {
                return false;
            }
        } else {
            setSetting.accept((OfflinePlayer)player, !getSetting.test(player));
        }
        String onOff = this.plugin.getLocalizedMessage((CommandSender)player, getSetting.test(player) ? "messages.info.on" : "messages.info.off");
        if (onOff == null) {
            onOff = String.valueOf(getSetting.test(player));
        }
        this.plugin.sendMessage(sender, "messages.info.settingState", new Replacement("%setting%", any ? "AnyContainer" : "SilentContainer"), new Replacement("%state%", onOff));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length != 1) {
            return Collections.emptyList();
        }
        return TabCompleter.completeString(args[0], new String[]{"check", "on", "off"});
    }
}

