/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal;

import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.EnderChest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public interface IAnySilentContainer {
    public boolean activateContainer(@NotNull Player var1, boolean var2, @NotNull Block var3);

    public void deactivateContainer(@NotNull Player var1);

    @Deprecated(forRemoval=true, since="4.1.9")
    default public boolean isAnyContainerNeeded(@NotNull Player player, @NotNull Block block) {
        return this.isAnyContainerNeeded(block);
    }

    default public boolean isAnyContainerNeeded(@NotNull Block block) {
        Chest chest;
        block12: {
            block11: {
                ShulkerBox shulker;
                BlockState blockState = block.getState();
                if (blockState instanceof Barrel) {
                    return false;
                }
                if (blockState instanceof EnderChest) {
                    return block.getRelative(0, 1, 0).getType().isOccluding();
                }
                if (blockState instanceof ShulkerBox && this.isShulkerBlocked(shulker = (ShulkerBox)blockState)) {
                    return true;
                }
                if (!(blockState instanceof org.bukkit.block.Chest)) {
                    return false;
                }
                if (this.isChestBlocked(block)) {
                    return true;
                }
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Chest)) break block11;
                chest = (Chest)blockData;
                if (((Chest)blockData).getType() != Chest.Type.SINGLE) break block12;
            }
            return false;
        }
        int ordinal = (chest.getFacing().ordinal() + 4 + (chest.getType() == Chest.Type.RIGHT ? -1 : 1)) % 4;
        BlockFace relativeFace = BlockFace.values()[ordinal];
        Block relative = block.getRelative(relativeFace);
        if (relative.getType() != block.getType()) {
            return false;
        }
        BlockData relativeData = relative.getBlockData();
        if (!(relativeData instanceof Chest)) {
            return false;
        }
        Chest relativeChest = (Chest)relativeData;
        if (relativeChest.getFacing() != chest.getFacing() || relativeChest.getType() != (chest.getType() == Chest.Type.RIGHT ? Chest.Type.LEFT : Chest.Type.RIGHT)) {
            return false;
        }
        return this.isChestBlocked(relative);
    }

    public boolean isShulkerBlocked(@NotNull ShulkerBox var1);

    default public boolean isChestBlocked(@NotNull Block chest) {
        Block relative = chest.getRelative(0, 1, 0);
        return relative.getType().isOccluding() || chest.getWorld().getNearbyEntities(BoundingBox.of((Block)relative), entity -> entity instanceof Cat).size() > 0;
    }

    default public boolean isAnySilentContainer(@NotNull Block block) {
        return this.isAnySilentContainer(block.getState());
    }

    default public boolean isAnySilentContainer(@NotNull BlockState blockState) {
        InventoryHolder holder;
        return blockState instanceof InventoryHolder && this.isAnySilentContainer(holder = (InventoryHolder)blockState) || blockState instanceof EnderChest;
    }

    default public boolean isAnySilentContainer(@NotNull InventoryHolder holder) {
        return holder instanceof EnderChest || holder instanceof org.bukkit.block.Chest || holder instanceof DoubleChest || holder instanceof ShulkerBox || holder instanceof Barrel;
    }
}

