/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R2;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.v1_20_R2.PlayerDataManager;
import com.lishid.openinv.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
implements IAnySilentContainer {
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer() {
        try {
            try {
                this.serverPlayerGameModeGameType = aks.class.getDeclaredField("b");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Logger logger = ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger();
                logger.warning("ServerPlayerGameMode#gameModeForPlayer's obfuscated name has changed!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(aks.class, cps.class);
            }
        }
        catch (SecurityException e) {
            Logger logger = ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger();
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    @Override
    public boolean isShulkerBlocked(@NotNull ShulkerBox shulkerBox) {
        dec shulkerBoxBlockEntity;
        World bukkitWorld = shulkerBox.getWorld();
        if (!(bukkitWorld instanceof CraftWorld)) {
            bukkitWorld = Bukkit.getWorld((UUID)bukkitWorld.getUID());
        }
        if (!(bukkitWorld instanceof CraftWorld)) {
            IllegalStateException exception = new IllegalStateException("AnySilentContainer access attempted on an unknown world!");
            ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return false;
        }
        CraftWorld craftWorld = (CraftWorld)bukkitWorld;
        akq world = craftWorld.getHandle();
        gw blockPosition = new gw(shulkerBox.getX(), shulkerBox.getY(), shulkerBox.getZ());
        dcv tile = world.c_(blockPosition);
        if (!(tile instanceof dec) || (shulkerBoxBlockEntity = (dec)tile).i() != dec.a.a) {
            return false;
        }
        dfj blockState = world.a_(blockPosition);
        ehi boundingBox = bzo.a((ha)((ha)blockState.c((dgm)czu.a)), (float)0.0f, (float)0.5f).a(blockPosition).h(1.0E-6);
        return !world.b(boundingBox);
    }

    @Override
    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull Block bukkitBlock) {
        gw blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        akr player = PlayerDataManager.getHandle(bukkitPlayer);
        cpv level = player.dL();
        dcv blockEntity = level.c_(blockPos = new gw(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof ddp) {
            ddp enderChestTile = (ddp)blockEntity;
            cfu enderChest = player.ge();
            enderChest.a(enderChestTile);
            player.a((bhb)new bhg((containerCounter, playerInventory, ignored) -> {
                cfq<?> containers = PlayerDataManager.getContainers(enderChest.b());
                int rows = enderChest.b() / 9;
                return new ces(containers, containerCounter, playerInventory, (bgr)enderChest, rows);
            }, (tl)tl.c((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof bhb)) {
            return false;
        }
        bhb menuProvider = (bhb)blockEntity;
        dfj blockState = level.a_(blockPos);
        csv block = blockState.b();
        if (block instanceof ctx) {
            ctx chestBlock = (ctx)block;
            menuProvider = chestBlock.getMenuProvider(blockState, level, blockPos, true);
            if (menuProvider == null) {
                ((OpenInv)OpenInv.getPlugin(OpenInv.class)).sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof dbj) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof czu) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof csc) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.e.b() == cps.d) {
            player.a(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof ddy) {
            ddy lootable = (ddy)blockEntity;
            if (lootable.h != null) {
                ((OpenInv)OpenInv.getPlugin(OpenInv.class)).sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        cps gameType = player.e.b();
        this.forceGameType(player, cps.d);
        player.a(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    @Override
    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        akr player = PlayerDataManager.getHandle(bukkitPlayer);
        cps gameType = player.e.b();
        this.forceGameType(player, cps.d);
        player.bS.transferTo((cel)player.bR, (CraftHumanEntity)player.getBukkitEntity());
        player.r();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(akr player, cps gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.e, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

