/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R2;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.IPlayerDataManager;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.OpenInventoryView;
import com.lishid.openinv.internal.v1_20_R2.OpenPlayer;
import com.lishid.openinv.internal.v1_20_R2.SpecialEnderChest;
import com.lishid.openinv.internal.v1_20_R2.SpecialPlayerInventory;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftContainer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataManager
implements IPlayerDataManager {
    private static boolean paper;
    @Nullable
    private Field bukkitEntity;

    public PlayerDataManager() {
        try {
            this.bukkitEntity = biq.class.getDeclaredField("bukkitEntity");
        }
        catch (NoSuchFieldException e) {
            Logger logger = ((OpenInv)JavaPlugin.getPlugin(OpenInv.class)).getLogger();
            logger.warning("Unable to obtain field to inject custom save process - certain player data may be lost when saving!");
            logger.log(Level.WARNING, e.getMessage(), e);
            this.bukkitEntity = null;
        }
    }

    @NotNull
    public static akr getHandle(Player player) {
        if (player instanceof CraftPlayer) {
            return ((CraftPlayer)player).getHandle();
        }
        Server server = player.getServer();
        akr nmsPlayer = null;
        if (server instanceof CraftServer) {
            nmsPlayer = ((CraftServer)server).getHandle().a(player.getUniqueId());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from Player implementation " + player.getClass().getName());
        }
        return nmsPlayer;
    }

    @Override
    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        ajn server = ((CraftServer)Bukkit.getServer()).getServer();
        akq worldServer = server.a(cpv.h);
        if (worldServer == null) {
            return null;
        }
        akr entity = this.createNewPlayer((MinecraftServer)server, worldServer, offline);
        entity.O().a();
        if (PlayerDataManager.loadData(entity)) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @NotNull
    private akr createNewPlayer(@NotNull MinecraftServer server, @NotNull akq worldServer, @NotNull OfflinePlayer offline) {
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        akf dummyInfo = new akf("en_us", 1, cbs.c, false, 0, akr.bB, true, false);
        akr entity = new akr(server, worldServer, profile, dummyInfo);
        try {
            this.injectPlayer(entity);
        }
        catch (IllegalAccessException e) {
            ((OpenInv)JavaPlugin.getPlugin(OpenInv.class)).getLogger().log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
        }
        return entity;
    }

    static boolean loadData(@NotNull akr player) {
        qw loadedData = player.d.ac().t.b((cbu)player);
        if (loadedData == null) {
            return false;
        }
        player.g(loadedData);
        player.a(loadedData);
        player.c(loadedData);
        if (paper) {
            PlayerDataManager.parseWorld(player, loadedData);
        }
        return true;
    }

    private static void parseWorld(@NotNull akr player, @NotNull qw loadedData) {
        World bukkitWorld;
        if (loadedData.e("WorldUUIDMost") && loadedData.e("WorldUUIDLeast")) {
            bukkitWorld = Bukkit.getServer().getWorld(new UUID(loadedData.i("WorldUUIDMost"), loadedData.i("WorldUUIDLeast")));
        } else if (loadedData.b("world", 8)) {
            bukkitWorld = Bukkit.getServer().getWorld(loadedData.l("world"));
        } else {
            dis.a((Dynamic)new Dynamic((DynamicOps)ri.a, (Object)loadedData.c("Dimension"))).resultOrPartial(((OpenInv)JavaPlugin.getPlugin(OpenInv.class)).getLogger()::warning).map(arg_0 -> ((MinecraftServer)player.d).a(arg_0)).ifPresentOrElse(arg_0 -> ((akr)player).c(arg_0), () -> player.spawnIn(null));
            return;
        }
        if (bukkitWorld == null) {
            player.spawnIn(null);
            return;
        }
        player.c(((CraftWorld)bukkitWorld).getHandle());
    }

    private void injectPlayer(akr player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.d.server, player));
    }

    @Override
    @NotNull
    public Player inject(@NotNull Player player) {
        try {
            akr nmsPlayer = PlayerDataManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof OpenPlayer) {
                OpenPlayer openPlayer = (OpenPlayer)craftPlayer;
                return openPlayer;
            }
            this.injectPlayer(nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            ((OpenInv)JavaPlugin.getPlugin(OpenInv.class)).getLogger().log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull Player player, final @NotNull ISpecialInventory inventory) {
        akr nmsPlayer = PlayerDataManager.getHandle(player);
        if (nmsPlayer.c == null) {
            return null;
        }
        InventoryView view = this.getView(player, inventory);
        if (view == null) {
            return player.openInventory(inventory.getBukkitInventory());
        }
        CraftContainer container = new CraftContainer(view, (cbu)nmsPlayer, nmsPlayer.nextContainerCounter()){

            public cfq<?> a() {
                return PlayerDataManager.getContainers(inventory.getBukkitInventory().getSize());
            }
        };
        container.setTitle((tl)tl.b((String)view.getTitle()));
        container = CraftEventFactory.callInventoryOpenEvent((akr)nmsPlayer, (cel)container);
        if (container == null) {
            return null;
        }
        nmsPlayer.c.b((vd)new yr(container.j, container.a(), (tl)tl.b((String)container.getBukkitView().getTitle())));
        nmsPlayer.bS = container;
        nmsPlayer.a((cel)container);
        return container.getBukkitView();
    }

    @Nullable
    private InventoryView getView(Player player, ISpecialInventory inventory) {
        if (inventory instanceof SpecialEnderChest) {
            return new OpenInventoryView(player, inventory, "container.enderchest", "'s Ender Chest");
        }
        if (inventory instanceof SpecialPlayerInventory) {
            return new OpenInventoryView(player, inventory, "container.player", "'s Inventory");
        }
        return null;
    }

    @NotNull
    static cfq<?> getContainers(int inventorySize) {
        return switch (inventorySize) {
            case 9 -> cfq.a;
            case 18 -> cfq.b;
            case 36 -> cfq.d;
            case 41, 45 -> cfq.e;
            case 54 -> cfq.f;
            default -> cfq.c;
        };
    }

    @Override
    public int convertToPlayerSlot(InventoryView view, int rawSlot) {
        int topSize = view.getTopInventory().getSize();
        if (topSize <= rawSlot) {
            return view.convertSlot(rawSlot);
        }
        if (rawSlot < 27) {
            return rawSlot + 9;
        }
        if (rawSlot < 36) {
            return rawSlot - 27;
        }
        if (rawSlot < 40) {
            return 36 + (39 - rawSlot);
        }
        if (rawSlot == 40) {
            return 40;
        }
        return -1;
    }

    static {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
            paper = true;
        }
        catch (ClassNotFoundException ignored) {
            paper = false;
        }
    }
}

