/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.lishid.openinv.OpenInv;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public record ConfigUpdater(OpenInv plugin) {
    public void checkForUpdates() {
        int version = this.plugin.getConfig().getInt("config-version", 1);
        Configuration defaults = this.plugin.getConfig().getDefaults();
        if (defaults == null || version >= defaults.getInt("config-version")) {
            return;
        }
        this.plugin.getLogger().info("Configuration update found! Performing update...");
        try {
            this.plugin.getConfig().save(new File(this.plugin.getDataFolder(), "config_old.yml"));
            this.plugin.getLogger().info("Backed up config.yml to config_old.yml before updating.");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not back up config.yml before updating!");
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (version < 2) {
                this.updateConfig1To2();
            }
            if (version < 3) {
                this.updateConfig2To3();
            }
            if (version < 4) {
                this.updateConfig3To4();
            }
            if (version < 5) {
                this.updateConfig4To5();
            }
            if (version < 6) {
                this.updateConfig5To6();
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.plugin.saveConfig();
                this.plugin.getLogger().info("Configuration update complete!");
            });
        });
    }

    private void updateConfig5To6() {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getConfig().set("settings.command.open.no-args-opens-self", (Object)false);
            this.plugin.getConfig().set("settings.command.searchcontainer.max-radius", (Object)10);
            this.plugin.getConfig().set("config-version", (Object)6);
        });
    }

    private void updateConfig4To5() {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getConfig().set("settings.disable-offline-access", (Object)false);
            this.plugin.getConfig().set("config-version", (Object)5);
        });
    }

    private void updateConfig3To4() {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getConfig().set("notify", null);
            this.plugin.getConfig().set("settings.locale", (Object)"en_US");
            this.plugin.getConfig().set("config-version", (Object)4);
        });
    }

    private void updateConfig2To3() {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getConfig().set("config-version", (Object)3);
            this.plugin.getConfig().set("items.open-inv", null);
            this.plugin.getConfig().set("ItemOpenInv", null);
            this.plugin.getConfig().set("toggles.items.open-inv", null);
            this.plugin.getConfig().set("settings.disable-saving", (Object)this.plugin.getConfig().getBoolean("DisableSaving", false));
            this.plugin.getConfig().set("DisableSaving", null);
        });
    }

    private void updateConfig1To2() {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean notifySilentChest = this.plugin.getConfig().getBoolean("NotifySilentChest", true);
            boolean notifyAnyChest = this.plugin.getConfig().getBoolean("NotifyAnyChest", true);
            this.plugin.getConfig().set("ItemOpenInvItemID", null);
            this.plugin.getConfig().set("NotifySilentChest", null);
            this.plugin.getConfig().set("NotifyAnyChest", null);
            this.plugin.getConfig().set("config-version", (Object)2);
            this.plugin.getConfig().set("notify.any-chest", (Object)notifyAnyChest);
            this.plugin.getConfig().set("notify.silent-chest", (Object)notifySilentChest);
        });
        this.updateToggles("AnyChest", "toggles.any-chest");
        this.updateToggles("SilentChest", "toggles.silent-chest");
    }

    private void updateToggles(String sectionName, String newSectionName) {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection(sectionName);
        if (section == null) {
            return;
        }
        Set keys = section.getKeys(false);
        if (keys.isEmpty()) {
            return;
        }
        HashMap<String, Boolean> toggles = new HashMap<String, Boolean>();
        for (String playerName : keys) {
            OfflinePlayer player = this.plugin.matchPlayer(playerName);
            if (player == null) continue;
            toggles.put(player.getUniqueId().toString(), section.getBoolean(playerName + ".toggle", false));
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getConfig().set(sectionName, null);
            ConfigurationSection newSection = this.plugin.getConfig().getConfigurationSection(newSectionName);
            if (newSection == null) {
                newSection = this.plugin.getConfig().createSection(newSectionName);
            }
            for (Map.Entry entry : toggles.entrySet()) {
                newSection.set((String)entry.getKey(), entry.getValue());
            }
        });
    }
}

