/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.lang;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.lang.Replacement;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageManager {
    private final OpenInv plugin;
    private final String defaultLocale;
    private final Map<String, YamlConfiguration> locales;

    public LanguageManager(@NotNull OpenInv plugin, @NotNull String defaultLocale) {
        this.plugin = plugin;
        this.defaultLocale = defaultLocale;
        this.locales = new HashMap<String, YamlConfiguration>();
        this.getOrLoadLocale(defaultLocale);
    }

    @NotNull
    private YamlConfiguration getOrLoadLocale(@NotNull String locale) {
        YamlConfiguration loaded = this.locales.get(locale);
        if (loaded != null) {
            return loaded;
        }
        File file = new File(this.plugin.getDataFolder(), locale + ".yml");
        YamlConfiguration localeConfig = this.loadLocale(locale, file);
        if (!locale.equals(this.defaultLocale)) {
            this.addTranslationFallthrough(locale, localeConfig, file);
            if (this.plugin.getConfig().getBoolean("settings.secret.warn-about-guess-section", true) && localeConfig.isConfigurationSection("guess")) {
                this.plugin.getLogger().info(() -> "[LanguageManager] Missing translations from " + locale + ".yml! Check the guess section!");
            }
        }
        this.locales.put(locale, localeConfig);
        return localeConfig;
    }

    @NotNull
    private YamlConfiguration loadLocale(@NotNull String locale, @NotNull File file) {
        YamlConfiguration localeConfigDefaults;
        InputStream resourceStream = this.plugin.getResource("locale/" + locale + ".yml");
        if (resourceStream == null) {
            localeConfigDefaults = new YamlConfiguration();
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
                localeConfigDefaults = YamlConfiguration.loadConfiguration((Reader)reader);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to load resource " + locale + ".yml");
                localeConfigDefaults = new YamlConfiguration();
            }
        }
        if (!file.exists()) {
            try {
                localeConfigDefaults.save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + locale + ".yml");
            }
            return localeConfigDefaults;
        }
        YamlConfiguration localeConfig = YamlConfiguration.loadConfiguration((File)file);
        List<String> newKeys = this.getMissingKeys((Configuration)localeConfigDefaults, arg_0 -> ((YamlConfiguration)localeConfig).isSet(arg_0));
        if (newKeys.isEmpty()) {
            return localeConfig;
        }
        ConfigurationSection guess = localeConfig.getConfigurationSection("guess");
        for (String newKey : newKeys) {
            localeConfig.set(newKey, localeConfigDefaults.get(newKey));
            if (guess == null) continue;
            guess.set(newKey, null);
        }
        if (guess != null && guess.getKeys(false).isEmpty()) {
            localeConfig.set("guess", null);
        }
        this.plugin.getLogger().info(() -> "[LanguageManager] Added new translation keys to " + locale + ".yml: " + String.join((CharSequence)", ", newKeys));
        try {
            localeConfig.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + locale + ".yml");
        }
        return localeConfig;
    }

    private void addTranslationFallthrough(@NotNull String locale, @NotNull YamlConfiguration localeConfig, @NotNull File file) {
        YamlConfiguration defaultLocaleConfig = this.locales.get(this.defaultLocale);
        List<String> missingKeys = this.getMissingKeys((Configuration)defaultLocaleConfig, key -> localeConfig.isSet(key) || localeConfig.isSet("guess." + key));
        if (!missingKeys.isEmpty()) {
            for (String key2 : missingKeys) {
                localeConfig.set("guess." + key2, defaultLocaleConfig.get(key2));
            }
            try {
                localeConfig.save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + locale + ".yml");
            }
        }
        localeConfig.setDefaults((Configuration)defaultLocaleConfig);
    }

    @NotNull
    private List<String> getMissingKeys(@NotNull Configuration configurationDefault, @NotNull Predicate<String> nodeSetPredicate) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        for (String key : configurationDefault.getKeys(true)) {
            if (configurationDefault.isConfigurationSection(key) || nodeSetPredicate.test(key)) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    @Nullable
    public String getValue(@NotNull String key, @Nullable String locale) {
        String value = this.getOrLoadLocale(locale == null ? this.defaultLocale : locale.toLowerCase()).getString(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        value = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
        return value;
    }

    @Nullable
    public String getValue(@NotNull String key, @Nullable String locale, Replacement ... replacements) {
        String value = this.getValue(key, locale);
        if (value == null) {
            return null;
        }
        for (Replacement replacement : replacements) {
            value = value.replace(replacement.placeholder(), replacement.value());
        }
        return value;
    }
}

