/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.IPlayerDataManager;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.InventoryAccess;
import java.lang.reflect.Constructor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class InternalAccessor {
    @NotNull
    private final Plugin plugin;
    private final String version;
    private boolean supported = false;
    private IPlayerDataManager playerDataManager;
    private IAnySilentContainer anySilentContainer;

    InternalAccessor(@NotNull Plugin plugin) {
        this.plugin = plugin;
        String packageName = plugin.getServer().getClass().getPackage().getName();
        this.version = packageName.substring(packageName.lastIndexOf(46) + 1);
        try {
            Class.forName("com.lishid.openinv.internal." + this.version + ".SpecialPlayerInventory");
            Class.forName("com.lishid.openinv.internal." + this.version + ".SpecialEnderChest");
            this.playerDataManager = this.createObject(IPlayerDataManager.class, "PlayerDataManager", new Object[0]);
            this.anySilentContainer = this.createObject(IAnySilentContainer.class, "AnySilentContainer", new Object[0]);
            this.supported = InventoryAccess.isUsable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getReleasesLink() {
        return switch (this.version) {
            case "1_4_5", "1_4_6", "v1_4_R1", "v1_5_R2", "v1_5_R3", "v1_6_R1", "v1_6_R2", "v1_6_R3", "v1_7_R1", "v1_7_R2", "v1_7_R3", "v1_7_R4", "v1_8_R1", "v1_8_R2", "v1_9_R1", "v1_9_R2", "v1_10_R1", "v1_11_R1", "v1_12_R1" -> "https://github.com/lishid/OpenInv/releases/tag/4.0.0 (OpenInv-legacy)";
            case "v1_13_R1" -> "https://github.com/lishid/OpenInv/releases/tag/4.0.0";
            case "v1_13_R2" -> "https://github.com/lishid/OpenInv/releases/tag/4.0.7";
            case "v1_14_R1" -> "https://github.com/lishid/OpenInv/releases/tag/4.1.1";
            case "v1_16_R1" -> "https://github.com/lishid/OpenInv/releases/tag/4.1.4";
            case "v1_8_R3", "v1_15_R1", "v1_16_R2" -> "https://github.com/lishid/OpenInv/releases/tag/4.1.5";
            case "v1_16_R3" -> "https://github.com/Jikoo/OpenInv/releases/tag/4.1.8";
            case "v1_17_R1", "v1_18_R1" -> "https://github.com/Jikoo/OpenInv/releases/tag/4.1.10";
            case "v1_19_R1" -> "https://github.com/Jikoo/OpenInv/releases/tag/4.2.2";
            case "v1_18_R2", "v1_19_R2" -> "https://github.com/Jikoo/OpenInv/releases/tag/4.3.0";
            case "v1_20_R1" -> "https://github.com/Jikoo/OpenInv/releases/tag/4.4.1";
            default -> "https://github.com/Jikoo/OpenInv/releases";
        };
    }

    @NotNull
    private <T> T createObject(@NotNull Class<? extends T> assignableClass, @NotNull String className, Object ... params) throws ClassCastException, ReflectiveOperationException {
        Class<?> internalClass = Class.forName("com.lishid.openinv.internal." + this.version + "." + className);
        if (params.length == 0) {
            return assignableClass.cast(internalClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        block0: for (Constructor<?> constructor : internalClass.getConstructors()) {
            Class<?>[] requiredClasses = constructor.getParameterTypes();
            if (requiredClasses.length != params.length) continue;
            for (int i = 0; i < params.length; ++i) {
                if (!requiredClasses[i].isAssignableFrom(params[i].getClass())) continue block0;
            }
            return assignableClass.cast(constructor.newInstance(params));
        }
        StringBuilder builder = new StringBuilder("Found class ").append(internalClass.getName()).append(" but cannot find any matching constructors for [");
        for (Object object : params) {
            builder.append(object.getClass().getName()).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        String message = builder.append(']').toString();
        this.plugin.getLogger().warning(message);
        throw new NoSuchMethodException(message);
    }

    @NotNull
    private <T extends ISpecialInventory> T createSpecialInventory(@NotNull Class<? extends T> assignableClass, @NotNull String className, @NotNull Player player, boolean online) throws InstantiationException {
        if (!this.supported) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", this.version));
        }
        try {
            return (T)((ISpecialInventory)this.createObject(assignableClass, className, player, online));
        }
        catch (Exception original) {
            InstantiationException exception = new InstantiationException(String.format("Unable to create a new %s", className));
            exception.initCause(original.fillInStackTrace());
            throw exception;
        }
    }

    @NotNull
    public IAnySilentContainer getAnySilentContainer() {
        if (!this.supported) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", this.version));
        }
        return this.anySilentContainer;
    }

    @NotNull
    public IPlayerDataManager getPlayerDataManager() {
        if (!this.supported) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", this.version));
        }
        return this.playerDataManager;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public ISpecialEnderChest newSpecialEnderChest(Player player, boolean online) throws InstantiationException {
        return this.createSpecialInventory(ISpecialEnderChest.class, "SpecialEnderChest", player, online);
    }

    public ISpecialPlayerInventory newSpecialPlayerInventory(Player player, boolean online) throws InstantiationException {
        return this.createSpecialInventory(ISpecialPlayerInventory.class, "SpecialPlayerInventory", player, online);
    }
}

