/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SearchInvCommand
implements TabExecutor {
    private final OpenInv plugin;

    public SearchInvCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Material material = null;
        if (args.length >= 1) {
            material = Material.getMaterial((String)args[0].toUpperCase());
        }
        if (material == null) {
            this.plugin.sendMessage(sender, "messages.error.invalidMaterial", new Replacement("%target%", args.length > 0 ? args[0] : "null"));
            return false;
        }
        int count = 1;
        if (args.length >= 2) {
            try {
                count = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                this.plugin.sendMessage(sender, "messages.error.invalidNumber", new Replacement("%target%", args[1]));
                return false;
            }
        }
        StringBuilder players = new StringBuilder();
        boolean searchInv = command.getName().equals("searchinv");
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            Object inventory = searchInv ? player.getInventory() : player.getEnderChest();
            if (!inventory.contains(material, count)) continue;
            players.append(player.getName()).append(", ");
        }
        if (players.length() <= 0) {
            this.plugin.sendMessage(sender, "messages.info.player.noMatches", new Replacement("%target%", material.name()));
            return true;
        }
        players.delete(players.length() - 2, players.length());
        this.plugin.sendMessage(sender, "messages.info.player.matches", new Replacement("%target%", material.name()), new Replacement("%detail%", players.toString()));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1 || args.length > 2 || !command.testPermissionSilent(sender)) {
            return Collections.emptyList();
        }
        String argument = args[args.length - 1];
        if (args.length == 1) {
            return TabCompleter.completeEnum(argument, Material.class);
        }
        return TabCompleter.completeInteger(argument);
    }
}

