/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public class OpenInventoryView
extends InventoryView {
    @NotNull
    private final Player player;
    @NotNull
    private final ISpecialInventory inventory;
    @NotNull
    private final String titleKey;
    @NotNull
    private final String titleDefaultSuffix;
    private String title;

    public OpenInventoryView(@NotNull Player player, @NotNull ISpecialInventory inventory, @NotNull String titleKey, @NotNull String titleDefaultSuffix) {
        this.player = player;
        this.inventory = inventory;
        this.titleKey = titleKey;
        this.titleDefaultSuffix = titleDefaultSuffix;
    }

    @NotNull
    public Inventory getTopInventory() {
        return this.inventory.getBukkitInventory();
    }

    @NotNull
    public Inventory getBottomInventory() {
        return this.getPlayer().getInventory();
    }

    @NotNull
    public HumanEntity getPlayer() {
        return this.player;
    }

    @NotNull
    public InventoryType getType() {
        return this.inventory.getBukkitInventory().getType();
    }

    @NotNull
    public String getTitle() {
        if (this.title == null) {
            HumanEntity owner = this.inventory.getPlayer();
            String localTitle = ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLocalizedMessage((CommandSender)this.player, this.titleKey, new Replacement("%player%", owner.getName()));
            this.title = Objects.requireNonNullElseGet(localTitle, () -> owner.getName() + this.titleDefaultSuffix);
        }
        return this.title;
    }
}

