/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public enum Permissions {
    OPENINV("openinv"),
    OVERRIDE("override"),
    EXEMPT("exempt"),
    CROSSWORLD("crossworld"),
    SILENT("silent"),
    SILENT_DEFAULT("silent.default", true),
    ANYCHEST("anychest"),
    ANY_DEFAULT("any.default", true),
    ENDERCHEST("openender"),
    ENDERCHEST_ALL("openenderall"),
    SEARCH("search"),
    EDITINV("editinv"),
    EDITENDER("editender"),
    OPENSELF("openself"),
    OPENONLINE("openonline"),
    OPENOFFLINE("openoffline"),
    SPECTATE("spectate");

    private final String permission;
    private final boolean uninheritable;

    private Permissions(String permission) {
        this(permission, false);
    }

    private Permissions(String permission, boolean uninheritable) {
        this.permission = "OpenInv." + permission;
        this.uninheritable = uninheritable;
    }

    public boolean hasPermission(@NotNull Permissible permissible) {
        boolean hasPermission = permissible.hasPermission(this.permission);
        if (this.uninheritable || hasPermission || permissible.isPermissionSet(this.permission)) {
            return hasPermission;
        }
        StringBuilder permissionDestroyer = new StringBuilder(this.permission);
        int lastPeriod = permissionDestroyer.lastIndexOf(".");
        while (lastPeriod > 0) {
            permissionDestroyer.delete(lastPeriod + 1, permissionDestroyer.length()).append('*');
            hasPermission = permissible.hasPermission(permissionDestroyer.toString());
            if (hasPermission || permissible.isPermissionSet(permissionDestroyer.toString())) {
                return hasPermission;
            }
            permissionDestroyer.delete(lastPeriod, permissionDestroyer.length());
            lastPeriod = permissionDestroyer.lastIndexOf(".");
        }
        return permissible.hasPermission("*");
    }
}

