/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TabCompleter {
    public static List<String> completeInteger(String argument) {
        if (!argument.isEmpty()) {
            try {
                Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                return Collections.emptyList();
            }
        }
        ArrayList<String> completions = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            completions.add(argument + i);
        }
        return completions;
    }

    public static List<String> completeEnum(String argument, Class<? extends Enum<?>> enumClazz) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (Enum<?> enumConstant : enumClazz.getEnumConstants()) {
            String name = enumConstant.name().toLowerCase();
            if (!name.startsWith(argument)) continue;
            completions.add(name);
        }
        return completions;
    }

    public static List<String> completeString(String argument, String[] options) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (String option : options) {
            if (!option.startsWith(argument)) continue;
            completions.add(option);
        }
        return completions;
    }

    public static List<String> completeOnlinePlayer(CommandSender sender, String argument) {
        ArrayList<String> completions = new ArrayList<String>();
        Player senderPlayer = sender instanceof Player ? (Player)sender : null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (senderPlayer != null && !senderPlayer.canSee(player) || !StringUtil.startsWithIgnoreCase((String)player.getName(), (String)argument)) continue;
            completions.add(player.getName());
        }
        return completions;
    }

    public static <T> List<String> completeObject(String argument, Function<T, String> converter, T[] options) {
        argument = argument.toLowerCase(Locale.ENGLISH);
        ArrayList<String> completions = new ArrayList<String>();
        for (T option : options) {
            String optionString = converter.apply(option).toLowerCase();
            if (!optionString.startsWith(argument)) continue;
            completions.add(optionString);
        }
        return completions;
    }

    private TabCompleter() {
    }
}

