/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEnchantCommand
implements TabExecutor {
    private final OpenInv plugin;

    public SearchEnchantCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        Enchantment enchant = null;
        int level = 0;
        for (String argument : args) {
            try {
                level = Integer.parseInt(argument);
            }
            catch (NumberFormatException numberFormatException) {
                NamespacedKey key;
                argument = argument.toLowerCase();
                int colon = argument.indexOf(58);
                try {
                    key = colon > -1 && colon < argument.length() - 1 ? new NamespacedKey(argument.substring(0, colon), argument.substring(colon + 1)) : NamespacedKey.minecraft((String)argument);
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                Enchantment localEnchant = Enchantment.getByKey((NamespacedKey)key);
                if (localEnchant == null) continue;
                enchant = localEnchant;
            }
        }
        if (level == 0 && enchant == null) {
            return false;
        }
        StringBuilder players = new StringBuilder();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            boolean flagInventory = this.containsEnchantment((Inventory)player.getInventory(), enchant, level);
            boolean flagEnder = this.containsEnchantment(player.getEnderChest(), enchant, level);
            if (!flagInventory && !flagEnder) continue;
            players.append(player.getName()).append(" (");
            if (flagInventory) {
                players.append("inv");
            }
            if (flagEnder) {
                if (flagInventory) {
                    players.append(',');
                }
                players.append("ender");
            }
            players.append("), ");
        }
        if (players.length() <= 0) {
            this.plugin.sendMessage(sender, "messages.info.player.noMatches", new Replacement("%target%", (enchant != null ? enchant.getKey().toString() : "") + " >= " + level));
            return true;
        }
        players.delete(players.length() - 2, players.length());
        this.plugin.sendMessage(sender, "messages.info.player.matches", new Replacement("%target%", (enchant != null ? enchant.getKey().toString() : "") + " >= " + level), new Replacement("%detail%", players.toString()));
        return true;
    }

    private boolean containsEnchantment(Inventory inventory, @Nullable Enchantment enchant, int minLevel) {
        for (ItemStack item : inventory.getContents()) {
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR) continue;
            if (enchant != null) {
                if (!item.containsEnchantment(enchant) || item.getEnchantmentLevel(enchant) < minLevel) continue;
                return true;
            }
            if (!item.hasItemMeta() || (meta = item.getItemMeta()) == null || !meta.hasEnchants()) continue;
            Iterator iterator = meta.getEnchants().values().iterator();
            while (iterator.hasNext()) {
                int enchLevel = (Integer)iterator.next();
                if (enchLevel < minLevel) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length < 1 || args.length > 2) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return TabCompleter.completeObject(args[0], enchantment -> enchantment.getKey().toString(), Enchantment.values());
        }
        return TabCompleter.completeInteger(args[1]);
    }
}

