/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R3;

import com.lishid.openinv.internal.v1_20_R3.PlayerDataManager;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayer
extends CraftPlayer {
    public OpenPlayer(CraftServer server, EntityPlayer entity) {
        super(server, entity);
    }

    public void loadData() {
        PlayerDataManager.loadData(this.getHandle());
    }

    public void saveData() {
        EntityPlayer player = this.getHandle();
        try {
            WorldNBTStorage worldNBTStorage = player.d.ae().t;
            NBTTagCompound playerData = player.f(new NBTTagCompound());
            this.setExtraData(playerData);
            if (!this.isOnline()) {
                NBTTagCompound oldData = worldNBTStorage.b((EntityHuman)player);
                this.revertSpecialValues(playerData, oldData);
            }
            Path playerDataDir = worldNBTStorage.getPlayerDir().toPath();
            Path file = Files.createTempFile(playerDataDir, player.cx() + "-", ".dat", new FileAttribute[0]);
            NBTCompressedStreamTools.a((NBTTagCompound)playerData, (Path)file);
            Path dataFile = playerDataDir.resolve(player.cx() + ".dat");
            Path backupFile = playerDataDir.resolve(player.cx() + ".dat_old");
            SystemUtils.a((Path)dataFile, (Path)file, (Path)backupFile);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.cy(), (Object)e);
        }
    }

    private void revertSpecialValues(@NotNull NBTTagCompound newData, @Nullable NBTTagCompound oldData) {
        if (oldData == null) {
            return;
        }
        if (oldData.b("RootVehicle", 10)) {
            try {
                NBTBase attach = oldData.c("Attach");
                if (attach != null) {
                    newData.a("Attach", GameProfileSerializer.a((NBTBase)attach));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            newData.a("Entity", (NBTBase)oldData.p("Entity"));
            newData.a("RootVehicle", (NBTBase)oldData.p("RootVehicle"));
        }
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", NBTNumber.class);
    }

    private <T extends NBTBase> void copyValue(@NotNull NBTTagCompound source, @NotNull NBTTagCompound target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        NBTTagCompound oldContainer = this.getTag(source, container, NBTTagCompound.class);
        NBTTagCompound newContainer = this.getTag(target, container, NBTTagCompound.class);
        if (oldContainer == null || newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends NBTBase> T getTag(@NotNull NBTTagCompound container, @NotNull String key, @NotNull Class<T> dataType) {
        NBTBase value = container.c(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((NBTBase)dataType.cast(value));
    }

    private <T extends NBTBase> void setTag(@NotNull NBTTagCompound container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            container.r(key);
        } else {
            container.a(key, data);
        }
    }
}

