/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R3;

import com.google.common.collect.ImmutableList;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.v1_20_R3.PlayerDataManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialPlayerInventory
extends PlayerInventory
implements ISpecialPlayerInventory {
    private final CraftInventory inventory = new CraftInventory((IInventory)this);
    private boolean playerOnline;
    private EntityHuman player;
    private NonNullList<ItemStack> items;
    private NonNullList<ItemStack> armor;
    private NonNullList<ItemStack> offhand;
    private List<NonNullList<ItemStack>> compartments;

    public SpecialPlayerInventory(@NotNull Player bukkitPlayer, @NotNull Boolean online) {
        super((EntityHuman)PlayerDataManager.getHandle(bukkitPlayer));
        this.playerOnline = online;
        this.player = this.m;
        this.l = this.player.fS().l;
        this.items = this.player.fS().i;
        this.armor = this.player.fS().j;
        this.offhand = this.player.fS().k;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    }

    @Override
    public void setPlayerOnline(@NotNull Player player) {
        if (this.playerOnline) {
            return;
        }
        EntityHuman offlinePlayer = this.player;
        EntityPlayer onlinePlayer = PlayerDataManager.getHandle(player);
        onlinePlayer.fS().transaction.addAll(this.transaction);
        this.player = onlinePlayer;
        PlayerInventory onlineInventory = onlinePlayer.fS();
        for (int i = 0; i < this.b(); ++i) {
            onlineInventory.a(i, this.getRawItem(i));
        }
        onlineInventory.l = this.l;
        this.items = onlineInventory.i;
        this.armor = onlineInventory.j;
        this.offhand = onlineInventory.k;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand);
        PlayerInventory offlineInventory = offlinePlayer.fS();
        offlineInventory.transaction.remove(offlinePlayer.getBukkitEntity());
        onlineInventory.transaction.addAll(offlineInventory.transaction);
        this.playerOnline = true;
    }

    @NotNull
    public CraftInventory getBukkitInventory() {
        return this.inventory;
    }

    @Override
    public void setPlayerOffline() {
        this.playerOnline = false;
    }

    @Override
    @NotNull
    public HumanEntity getPlayer() {
        return this.player.getBukkitEntity();
    }

    @NotNull
    private ItemStack getRawItem(int i) {
        if (i < 0) {
            return ItemStack.f;
        }
        for (NonNullList<ItemStack> list : this.compartments) {
            if (i < list.size()) {
                return (ItemStack)list.get(i);
            }
            i -= list.size();
        }
        return ItemStack.f;
    }

    private void setRawItem(int i, @NotNull ItemStack itemStack) {
        if (i < 0) {
            return;
        }
        for (NonNullList<ItemStack> list : this.compartments) {
            if (i < list.size()) {
                list.set(i, (Object)itemStack);
            }
            i -= list.size();
        }
    }

    @NotNull
    private IndexedCompartment getIndexedContent(int index) {
        if (index < this.items.size()) {
            return new IndexedCompartment(this.items, this.getReversedItemSlotNum(index));
        }
        if ((index -= this.items.size()) < this.armor.size()) {
            return new IndexedCompartment(this.armor, this.getReversedArmorSlotNum(index));
        }
        if ((index -= this.armor.size()) < this.offhand.size()) {
            return new IndexedCompartment(this.offhand, index);
        }
        return new IndexedCompartment(null, index -= this.offhand.size());
    }

    private int getReversedArmorSlotNum(int i) {
        if (i == 0) {
            return 3;
        }
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 0;
        }
        return i;
    }

    private int getReversedItemSlotNum(int i) {
        if (i >= 27) {
            return i - 27;
        }
        return i + 9;
    }

    private boolean contains(Predicate<ItemStack> predicate) {
        return this.compartments.stream().flatMap(Collection::stream).anyMatch(predicate);
    }

    public List<ItemStack> getArmorContents() {
        return this.armor;
    }

    public void onOpen(CraftHumanEntity who) {
        this.player.fS().onOpen(who);
    }

    public void onClose(CraftHumanEntity who) {
        this.player.fS().onClose(who);
    }

    public List<HumanEntity> getViewers() {
        return this.player.fS().getViewers();
    }

    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    public int ak_() {
        return this.player.fS().ak_();
    }

    public void setMaxStackSize(int size) {
        this.player.fS().setMaxStackSize(size);
    }

    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public boolean ae() {
        return false;
    }

    public List<ItemStack> getContents() {
        return this.compartments.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public ItemStack f() {
        return SpecialPlayerInventory.d((int)this.l) ? (ItemStack)this.items.get(this.l) : ItemStack.f;
    }

    private boolean hasRemainingSpaceForItem(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.b() && ItemStack.c((ItemStack)itemstack, (ItemStack)itemstack1) && itemstack.h() && itemstack.L() < itemstack.g() && itemstack.L() < this.ak_();
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.L();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = this.getRawItem(i);
            if (itemstack1.b()) {
                return itemstack.L();
            }
            if (this.hasRemainingSpaceForItem(itemstack1, itemstack)) {
                remains -= (itemstack1.g() < this.ak_() ? itemstack1.g() : this.ak_()) - itemstack1.L();
            }
            if (remains > 0) continue;
            return itemstack.L();
        }
        ItemStack offhandItemStack = this.getRawItem(this.items.size() + this.armor.size());
        if (this.hasRemainingSpaceForItem(offhandItemStack, itemstack)) {
            remains -= (offhandItemStack.g() < this.ak_() ? offhandItemStack.g() : this.ak_()) - offhandItemStack.L();
        }
        return remains <= 0 ? itemstack.L() : itemstack.L() - remains;
    }

    public int h() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).b()) continue;
            return i;
        }
        return -1;
    }

    public void a(ItemStack itemstack) {
        int i = this.b(itemstack);
        if (SpecialPlayerInventory.d((int)i)) {
            this.l = i;
        } else if (i == -1) {
            int j;
            this.l = this.i();
            if (!((ItemStack)this.items.get(this.l)).b() && (j = this.h()) != -1) {
                this.items.set(j, (Object)((ItemStack)this.items.get(this.l)));
            }
            this.items.set(this.l, (Object)itemstack);
        } else {
            this.c(i);
        }
    }

    public void c(int i) {
        this.l = this.i();
        ItemStack itemstack = (ItemStack)this.items.get(this.l);
        this.items.set(this.l, (Object)((ItemStack)this.items.get(i)));
        this.items.set(i, (Object)itemstack);
    }

    public int b(ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).b() || !ItemStack.c((ItemStack)itemstack, (ItemStack)((ItemStack)this.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int c(ItemStack itemStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack localItem = (ItemStack)this.items.get(i);
            if (((ItemStack)this.items.get(i)).b() || !ItemStack.c((ItemStack)itemStack, (ItemStack)((ItemStack)this.items.get(i))) || ((ItemStack)this.items.get(i)).j() || localItem.E() || localItem.A()) continue;
            return i;
        }
        return -1;
    }

    public int i() {
        int i;
        int j;
        for (j = 0; j < 9; ++j) {
            i = (this.l + j) % 9;
            if (!((ItemStack)this.items.get(i)).b()) continue;
            return i;
        }
        for (j = 0; j < 9; ++j) {
            i = (this.l + j) % 9;
            if (((ItemStack)this.items.get(i)).E()) continue;
            return i;
        }
        return this.l;
    }

    public void a(double d0) {
        if (d0 > 0.0) {
            d0 = 1.0;
        }
        if (d0 < 0.0) {
            d0 = -1.0;
        }
        this.l = (int)((double)this.l - d0);
        while (this.l < 0) {
            this.l += 9;
        }
        while (this.l >= 9) {
            this.l -= 9;
        }
    }

    public int a(Predicate<ItemStack> predicate, int i, IInventory container) {
        int b0 = 0;
        boolean flag = i == 0;
        int j = b0 + ContainerUtil.a((IInventory)this, predicate, (int)(i - b0), (boolean)flag);
        j += ContainerUtil.a((IInventory)container, predicate, (int)(i - j), (boolean)flag);
        ItemStack itemstack = this.player.bS.g();
        j += ContainerUtil.a((ItemStack)itemstack, predicate, (int)(i - j), (boolean)flag);
        if (itemstack.b()) {
            this.player.bS.b(ItemStack.f);
        }
        return j;
    }

    private int addResource(ItemStack itemstack) {
        int i = this.d(itemstack);
        if (i == -1) {
            i = this.h();
        }
        return i == -1 ? itemstack.L() : this.addResource(i, itemstack);
    }

    private int addResource(int i, ItemStack itemstack) {
        int k;
        Item item = itemstack.d();
        int j = itemstack.L();
        ItemStack localItemStack = this.getRawItem(i);
        if (localItemStack.b()) {
            localItemStack = new ItemStack((IMaterial)item, 0);
            if (itemstack.u()) {
                localItemStack.c(itemstack.v().h());
            }
            this.setRawItem(i, localItemStack);
        }
        if ((k = Math.min(j, localItemStack.g() - localItemStack.L())) > this.ak_() - localItemStack.L()) {
            k = this.ak_() - localItemStack.L();
        }
        if (k != 0) {
            j -= k;
            localItemStack.g(k);
            localItemStack.e(5);
        }
        return j;
    }

    public int d(ItemStack itemstack) {
        if (this.hasRemainingSpaceForItem(this.getRawItem(this.l), itemstack)) {
            return this.l;
        }
        if (this.hasRemainingSpaceForItem(this.getRawItem(40), itemstack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem((ItemStack)this.items.get(i), itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void j() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                if (((ItemStack)compartment.get(i)).b()) continue;
                ((ItemStack)compartment.get(i)).a(this.player.dM(), (Entity)this.player, i, this.l == i);
            }
        }
    }

    public boolean e(ItemStack itemStack) {
        return this.c(-1, itemStack);
    }

    public boolean c(int i, ItemStack itemStack) {
        if (itemStack.b()) {
            return false;
        }
        try {
            int j;
            if (itemStack.j()) {
                if (i == -1) {
                    i = this.h();
                }
                if (i >= 0) {
                    this.items.set(i, (Object)itemStack.p());
                    ((ItemStack)this.items.get(i)).e(5);
                    itemStack.f(0);
                    return true;
                }
                if (this.player.fT().d) {
                    itemStack.f(0);
                    return true;
                }
                return false;
            }
            do {
                j = itemStack.L();
                if (i == -1) {
                    itemStack.f(this.addResource(itemStack));
                    continue;
                }
                itemStack.f(this.addResource(i, itemStack));
            } while (!itemStack.b() && itemStack.L() < j);
            if (itemStack.L() == j && this.player.fT().d) {
                itemStack.f(0);
                return true;
            }
            return itemStack.L() < j;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.a((Throwable)var6, (String)"Adding item to inventory");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Item being added");
            crashReportCategory.a("Item ID", (Object)Item.a((Item)itemStack.d()));
            crashReportCategory.a("Item data", (Object)itemStack.k());
            crashReportCategory.a("Item name", () -> itemStack.y().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void f(ItemStack itemStack) {
        this.a(itemStack, true);
    }

    public void a(ItemStack itemStack, boolean flag) {
        while (!itemStack.b()) {
            int i = this.d(itemStack);
            if (i == -1) {
                i = this.h();
            }
            if (i != -1) {
                int j = itemStack.g() - this.getRawItem(i).L();
                if (!this.c(i, itemStack.a(j)) || !flag || !(this.player instanceof EntityPlayer)) continue;
                ((EntityPlayer)this.player).c.b((Packet)new PacketPlayOutSetSlot(-2, 0, i, this.getRawItem(i)));
                continue;
            }
            this.player.a(itemStack, false);
            break;
        }
    }

    public ItemStack a(int rawIndex, int j) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null || ((ItemStack)indexedCompartment.compartment().get(indexedCompartment.index())).b()) {
            return ItemStack.f;
        }
        return ContainerUtil.a(indexedCompartment.compartment(), (int)indexedCompartment.index(), (int)j);
    }

    public void g(ItemStack itemStack) {
        block0: for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                if (compartment.get(i) != itemStack) continue;
                compartment.set(i, (Object)ItemStack.f);
                continue block0;
            }
        }
    }

    public ItemStack b(int rawIndex) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            return ItemStack.f;
        }
        ItemStack removed = (ItemStack)indexedCompartment.compartment().set(indexedCompartment.index(), (Object)ItemStack.f);
        if (removed.b()) {
            return ItemStack.f;
        }
        return removed;
    }

    public void a(int rawIndex, ItemStack itemStack) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            this.player.a(itemStack, true);
            return;
        }
        indexedCompartment.compartment().set(indexedCompartment.index(), (Object)itemStack);
    }

    public float a(IBlockData blockState) {
        return ((ItemStack)this.items.get(this.l)).a(blockState);
    }

    public NBTTagList a(NBTTagList listTag) {
        NBTTagCompound compoundTag;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).b()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).b(compoundTag);
            listTag.add((Object)compoundTag);
        }
        for (i = 0; i < this.armor.size(); ++i) {
            if (((ItemStack)this.armor.get(i)).b()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(i + 100));
            ((ItemStack)this.armor.get(i)).b(compoundTag);
            listTag.add((Object)compoundTag);
        }
        for (i = 0; i < this.offhand.size(); ++i) {
            if (((ItemStack)this.offhand.get(i)).b()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(i + 150));
            ((ItemStack)this.offhand.get(i)).b(compoundTag);
            listTag.add((Object)compoundTag);
        }
        return listTag;
    }

    public void b(NBTTagList listTag) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            NBTTagCompound compoundTag = listTag.a(i);
            int j = compoundTag.f("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.a((NBTTagCompound)compoundTag);
            if (itemstack.b()) continue;
            if (j < this.items.size()) {
                this.items.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offhand.size() + 150) continue;
            this.offhand.set(j - 150, (Object)itemstack);
        }
    }

    public int b() {
        return 45;
    }

    public boolean ai_() {
        return !this.contains(itemStack -> !itemStack.b());
    }

    public ItemStack a(int rawIndex) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            return ItemStack.f;
        }
        return (ItemStack)indexedCompartment.compartment().get(indexedCompartment.index());
    }

    public IChatBaseComponent ad() {
        return this.player.ad();
    }

    public ItemStack e(int index) {
        return (ItemStack)this.armor.get(index);
    }

    public void a(DamageSource damagesource, float damage, int[] armorIndices) {
        if (damage > 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int index : armorIndices) {
                ItemStack itemstack = (ItemStack)this.armor.get(index);
                if (damagesource.a(DamageTypeTags.j) && itemstack.d().w() || !(itemstack.d() instanceof ItemArmor)) continue;
                itemstack.a((int)damage, (EntityLiving)this.player, localPlayer -> localPlayer.d(EnumItemSlot.a((EnumItemSlot.Function)EnumItemSlot.Function.b, (int)index)));
            }
        }
    }

    public void k() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                ItemStack itemstack = (ItemStack)compartment.get(i);
                if (itemstack.b()) continue;
                this.player.a(itemstack, true, false);
                compartment.set(i, (Object)ItemStack.f);
            }
        }
    }

    public void e() {
        super.e();
    }

    public int l() {
        return super.l();
    }

    public boolean a(EntityHuman player) {
        return true;
    }

    public boolean h(ItemStack itemstack) {
        return this.contains(itemStack -> itemStack.b() && itemStack.a(itemstack.d()));
    }

    public boolean a(TagKey<Item> tagKey) {
        return this.contains(itemStack -> !itemStack.b() && itemStack.a(tagKey));
    }

    public void a(PlayerInventory inventory) {
        Function<Integer, ItemStack> getter;
        if (inventory instanceof SpecialPlayerInventory) {
            SpecialPlayerInventory specialPlayerInventory = (SpecialPlayerInventory)inventory;
            getter = specialPlayerInventory::getRawItem;
        } else {
            getter = arg_0 -> ((PlayerInventory)inventory).a(arg_0);
        }
        for (int i = 0; i < this.b(); ++i) {
            this.setRawItem(i, getter.apply(i));
        }
        this.l = inventory.l;
    }

    public void a() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            compartment.clear();
        }
    }

    public void a(AutoRecipeStackManager stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.a(itemstack);
        }
    }

    public ItemStack a(boolean dropWholeStack) {
        ItemStack itemstack = this.f();
        return itemstack.b() ? ItemStack.f : this.a(this.l, dropWholeStack ? itemstack.L() : 1);
    }

    private record IndexedCompartment(@Nullable NonNullList<ItemStack> compartment, int index) {
    }
}

