/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.Permissions;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

record PlayerListener(OpenInv plugin) implements Listener
{
    @EventHandler(priority=EventPriority.LOWEST)
    private void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        this.plugin.setPlayerOnline(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        this.plugin.setPlayerOffline(event.getPlayer());
    }

    @EventHandler
    private void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        this.plugin.changeWorld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        boolean silent;
        if (!PlayerInteractEvent.class.equals(event.getClass())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getPlayer().isSneaking() || event.useInteractedBlock() == Event.Result.DENY || event.getClickedBlock() == null || !this.plugin.getAnySilentContainer().isAnySilentContainer(event.getClickedBlock())) {
            return;
        }
        Player player = event.getPlayer();
        boolean any = Permissions.ANYCHEST.hasPermission((Permissible)player) && this.plugin.getAnyContainerStatus((OfflinePlayer)player);
        boolean needsAny = this.plugin.getAnySilentContainer().isAnyContainerNeeded(event.getClickedBlock());
        if (!any && needsAny) {
            return;
        }
        boolean bl = silent = Permissions.SILENT.hasPermission((Permissible)player) && this.plugin.getSilentContainerStatus((OfflinePlayer)player);
        if (any || silent) {
            if (this.plugin.getAnySilentContainer().activateContainer(player, silent, event.getClickedBlock())) {
                if (silent && needsAny) {
                    this.plugin.sendSystemMessage(player, "messages.info.containerBlockedSilent");
                } else if (needsAny) {
                    this.plugin.sendSystemMessage(player, "messages.info.containerBlocked");
                } else if (silent) {
                    this.plugin.sendSystemMessage(player, "messages.info.containerSilent");
                }
            }
            event.setCancelled(true);
        }
    }
}

