/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class OpenInvCommand
implements TabExecutor {
    private final OpenInv plugin;
    private final HashMap<Player, String> openInvHistory = new HashMap();
    private final HashMap<Player, String> openEnderHistory = new HashMap();

    public OpenInvCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String noArgValue;
        final boolean openInv = command.getName().equals("openinv");
        if (openInv && args.length > 0 && (args[0].equalsIgnoreCase("help") || args[0].equals("?"))) {
            this.showHelp(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, "messages.error.consoleUnsupported");
            return true;
        }
        final Player player = (Player)sender;
        if (this.plugin.noArgsOpensSelf()) {
            noArgValue = player.getUniqueId().toString();
        } else {
            noArgValue = (openInv ? this.openInvHistory : this.openEnderHistory).get(player);
            if (noArgValue == null || noArgValue.isEmpty()) {
                noArgValue = player.getUniqueId().toString();
                (openInv ? this.openInvHistory : this.openEnderHistory).put(player, noArgValue);
            }
        }
        final String name = args.length < 1 ? noArgValue : args[0];
        new BukkitRunnable(){

            public void run() {
                final OfflinePlayer offlinePlayer = OpenInvCommand.this.plugin.matchPlayer(name);
                if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore() && !offlinePlayer.isOnline()) {
                    OpenInvCommand.this.plugin.sendMessage((CommandSender)player, "messages.error.invalidPlayer");
                    return;
                }
                new BukkitRunnable(){

                    public void run() {
                        if (!player.isOnline()) {
                            return;
                        }
                        OpenInvCommand.this.openInventory(player, offlinePlayer, openInv);
                    }
                }.runTask((Plugin)OpenInvCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
        return true;
    }

    private void showHelp(CommandSender sender) {
        for (String commandName : this.plugin.getDescription().getCommands().keySet()) {
            PluginCommand command = this.plugin.getCommand(commandName);
            if (command == null || !command.testPermissionSilent(sender)) continue;
            sender.sendMessage(command.getUsage().replace("<command>", commandName));
            List aliases = command.getAliases();
            if (aliases.isEmpty()) continue;
            StringJoiner aliasJoiner = new StringJoiner(", ", "   (aliases: ", ")");
            for (String alias : aliases) {
                aliasJoiner.add(alias);
            }
            sender.sendMessage(aliasJoiner.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openInventory(Player player, OfflinePlayer target, boolean openinv) {
        ISpecialInventory iSpecialInventory;
        Player onlineTarget;
        boolean online;
        block14: {
            online = target.isOnline();
            if (!online) {
                if (!this.plugin.disableOfflineAccess() && Permissions.OPENOFFLINE.hasPermission((Permissible)player)) {
                    onlineTarget = this.plugin.loadPlayer(target);
                    break block14;
                } else {
                    this.plugin.sendMessage((CommandSender)player, "messages.error.permissionPlayerOffline");
                    return;
                }
            }
            if (!Permissions.OPENONLINE.hasPermission((Permissible)player)) {
                this.plugin.sendMessage((CommandSender)player, "messages.error.permissionPlayerOnline");
                return;
            }
            onlineTarget = target.getPlayer();
        }
        if (onlineTarget == null) {
            this.plugin.sendMessage((CommandSender)player, "messages.error.invalidPlayer");
            return;
        }
        if (onlineTarget.equals((Object)player)) {
            if (openinv && !Permissions.OPENSELF.hasPermission((Permissible)player)) {
                this.plugin.sendMessage((CommandSender)player, "messages.error.permissionOpenSelf");
                return;
            }
        } else {
            if (!openinv && !Permissions.ENDERCHEST_ALL.hasPermission((Permissible)player)) {
                this.plugin.sendMessage((CommandSender)player, "messages.error.permissionEnderAll");
                return;
            }
            if (!Permissions.OVERRIDE.hasPermission((Permissible)player) && Permissions.EXEMPT.hasPermission((Permissible)onlineTarget)) {
                this.plugin.sendMessage((CommandSender)player, "messages.error.permissionExempt", new Replacement("%target%", onlineTarget.getDisplayName()));
                return;
            }
            if (!Permissions.CROSSWORLD.hasPermission((Permissible)player) && !onlineTarget.getWorld().equals((Object)player.getWorld())) {
                this.plugin.sendMessage((CommandSender)player, "messages.error.permissionCrossWorld", new Replacement("%target%", onlineTarget.getDisplayName()));
                return;
            }
        }
        if (!this.plugin.noArgsOpensSelf()) {
            (openinv ? this.openInvHistory : this.openEnderHistory).put(player, target.getUniqueId().toString());
        }
        try {
            iSpecialInventory = openinv ? this.plugin.getSpecialInventory(onlineTarget, online) : this.plugin.getSpecialEnderChest(onlineTarget, online);
        }
        catch (Exception e) {
            this.plugin.sendMessage((CommandSender)player, "messages.error.commandException");
            e.printStackTrace();
            return;
        }
        this.plugin.openInventory(player, iSpecialInventory);
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length != 1) {
            return Collections.emptyList();
        }
        return TabCompleter.completeOnlinePlayer(sender, args[0]);
    }
}

