/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R3;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.v1_20_R3.PlayerDataManager;
import com.lishid.openinv.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
implements IAnySilentContainer {
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer() {
        try {
            try {
                this.serverPlayerGameModeGameType = anf.class.getDeclaredField("b");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Logger logger = ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger();
                logger.warning("ServerPlayerGameMode#gameModeForPlayer's obfuscated name has changed!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(anf.class, ctm.class);
            }
        }
        catch (SecurityException e) {
            Logger logger = ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger();
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    @Override
    public boolean isShulkerBlocked(@NotNull ShulkerBox shulkerBox) {
        did shulkerBoxBlockEntity;
        World bukkitWorld = shulkerBox.getWorld();
        if (!(bukkitWorld instanceof CraftWorld)) {
            bukkitWorld = Bukkit.getWorld((UUID)bukkitWorld.getUID());
        }
        if (!(bukkitWorld instanceof CraftWorld)) {
            IllegalStateException exception = new IllegalStateException("AnySilentContainer access attempted on an unknown world!");
            ((OpenInv)OpenInv.getPlugin(OpenInv.class)).getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return false;
        }
        CraftWorld craftWorld = (CraftWorld)bukkitWorld;
        and world = craftWorld.getHandle();
        hx blockPosition = new hx(shulkerBox.getX(), shulkerBox.getY(), shulkerBox.getZ());
        dgv tile = world.c_(blockPosition);
        if (!(tile instanceof did) || (shulkerBoxBlockEntity = (did)tile).m() != did.a.a) {
            return false;
        }
        djh blockState = world.a_(blockPosition);
        elo boundingBox = ccv.a((ic)((ic)blockState.c((dkk)ddo.b)), (float)0.0f, (float)0.5f).a(blockPosition).h(1.0E-6);
        return !world.b(boundingBox);
    }

    @Override
    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull Block bukkitBlock) {
        hx blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        ane player = PlayerDataManager.getHandle(bukkitPlayer);
        ctp level = player.dM();
        dgv blockEntity = level.c_(blockPos = new hx(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof dhq) {
            dhq enderChestTile = (dhq)blockEntity;
            cjn enderChest = player.gf();
            enderChest.a(enderChestTile);
            player.a((bke)new bkk((containerCounter, playerInventory, ignored) -> {
                cji<?> containers = PlayerDataManager.getContainers(enderChest.b());
                int rows = enderChest.b() / 9;
                return new cii(containers, containerCounter, playerInventory, (bju)enderChest, rows);
            }, (vf)vf.c((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof bke)) {
            return false;
        }
        bke menuProvider = (bke)blockEntity;
        djh blockState = level.a_(blockPos);
        cwq block = blockState.b();
        if (block instanceof cxt) {
            cxt chestBlock = (cxt)block;
            menuProvider = chestBlock.getMenuProvider(blockState, level, blockPos, true);
            if (menuProvider == null) {
                ((OpenInv)OpenInv.getPlugin(OpenInv.class)).sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof dfd) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof ddo) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof cvw) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.e.b() == ctm.d) {
            player.a(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof dhz) {
            dhz lootable = (dhz)blockEntity;
            if (lootable.m != null) {
                ((OpenInv)OpenInv.getPlugin(OpenInv.class)).sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        ctm gameType = player.e.b();
        this.forceGameType(player, ctm.d);
        player.a(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    @Override
    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        ane player = PlayerDataManager.getHandle(bukkitPlayer);
        ctm gameType = player.e.b();
        this.forceGameType(player, ctm.d);
        player.bS.transferTo((cib)player.bR, (CraftHumanEntity)player.getBukkitEntity());
        player.s();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(ane player, ctm gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.e, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

