/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.lishid.openinv.internal.IInventoryAccess;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.ReflectionHelper;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventoryAccess
implements IInventoryAccess {
    private static Class<?> craftInventory = null;
    private static Method getInventory = null;

    @Deprecated(forRemoval=true)
    public static boolean isUseable() {
        return InventoryAccess.isUsable();
    }

    public static boolean isUsable() {
        return craftInventory != null && getInventory != null;
    }

    public static boolean isPlayerInventory(@NotNull Inventory inventory) {
        return InventoryAccess.getPlayerInventory(inventory) != null;
    }

    @Nullable
    public static ISpecialPlayerInventory getPlayerInventory(@NotNull Inventory inventory) {
        return InventoryAccess.getSpecialInventory(ISpecialPlayerInventory.class, inventory);
    }

    public static boolean isEnderChest(@NotNull Inventory inventory) {
        return InventoryAccess.getEnderChest(inventory) != null;
    }

    @Nullable
    public static ISpecialEnderChest getEnderChest(@NotNull Inventory inventory) {
        return InventoryAccess.getSpecialInventory(ISpecialEnderChest.class, inventory);
    }

    @Nullable
    private static <T extends ISpecialInventory> T getSpecialInventory(@NotNull Class<T> expected, @NotNull Inventory inventory) {
        Object inv;
        if (InventoryAccess.isUsable() && craftInventory.isAssignableFrom(inventory.getClass())) {
            try {
                inv = getInventory.invoke((Object)inventory, new Object[0]);
                if (expected.isInstance(inv)) {
                    return (T)((ISpecialInventory)expected.cast(inv));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (expected.isInstance(inv = ReflectionHelper.grabObjectByType(inventory, expected))) {
            return (T)((ISpecialInventory)expected.cast(inv));
        }
        return null;
    }

    @Deprecated(forRemoval=true, since="4.2.0")
    public InventoryAccess() {
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        try {
            craftInventory = Class.forName(packageName + ".inventory.CraftInventory");
            getInventory = craftInventory.getDeclaredMethod("getInventory", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

