/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

public class StringMetric {
    public static float compareJaroWinkler(String a2, String b) {
        float jaroScore = StringMetric.compareJaro(a2, b);
        if (jaroScore < 0.7f) {
            return jaroScore;
        }
        String prefix = StringMetric.commonPrefix(a2, b);
        int prefixLength = Math.min(prefix.codePointCount(0, prefix.length()), 4);
        return jaroScore + (float)prefixLength * 0.1f * (1.0f - jaroScore);
    }

    private static float compareJaro(String a2, String b) {
        int commonCharacters;
        if (a2.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a2.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        int[] charsA = a2.codePoints().toArray();
        int[] charsB = b.codePoints().toArray();
        int halfLength = Math.max(0, Math.max(charsA.length, charsB.length) / 2 - 1);
        int[] commonA = StringMetric.getCommonCodePoints(charsA, charsB, halfLength);
        int[] commonB = StringMetric.getCommonCodePoints(charsB, charsA, halfLength);
        float transpositions = 0.0f;
        int length = commonA.length;
        for (commonCharacters = 0; commonCharacters < length && commonA[commonCharacters] > -1; ++commonCharacters) {
            if (commonA[commonCharacters] == commonB[commonCharacters]) continue;
            transpositions += 1.0f;
        }
        if (commonCharacters == 0) {
            return 0.0f;
        }
        float aCommonRatio = (float)commonCharacters / (float)charsA.length;
        float bCommonRatio = (float)commonCharacters / (float)charsB.length;
        float transpositionRatio = ((float)commonCharacters - transpositions / 2.0f) / (float)commonCharacters;
        return (aCommonRatio + bCommonRatio + transpositionRatio) / 3.0f;
    }

    private static int[] getCommonCodePoints(int[] charsA, int[] charsB, int separation) {
        int[] common = new int[Math.min(charsA.length, charsB.length)];
        boolean[] matched = new boolean[charsB.length];
        int commonIndex = 0;
        int length = charsA.length;
        for (int i = 0; i < length; ++i) {
            int character = charsA[i];
            int index = StringMetric.indexOf(character, charsB, i - separation, i + separation + 1, matched);
            if (index <= -1) continue;
            common[commonIndex++] = character;
            matched[index] = true;
        }
        if (commonIndex < common.length) {
            common[commonIndex] = -1;
        }
        return common;
    }

    private static int indexOf(int character, int[] buffer, int fromIndex, int toIndex, boolean[] matched) {
        int length = Math.min(toIndex, buffer.length);
        for (int j = Math.max(0, fromIndex); j < length; ++j) {
            if (buffer[j] != character || matched[j]) continue;
            return j;
        }
        return -1;
    }

    private static String commonPrefix(CharSequence a2, CharSequence b) {
        int p2;
        int maxPrefixLength = Math.min(a2.length(), b.length());
        for (p2 = 0; p2 < maxPrefixLength && a2.charAt(p2) == b.charAt(p2); ++p2) {
        }
        if (StringMetric.validSurrogatePairAt(a2, p2 - 1) || StringMetric.validSurrogatePairAt(b, p2 - 1)) {
            --p2;
        }
        return a2.subSequence(0, p2).toString();
    }

    private static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    private StringMetric() {
    }
}

