/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.InventoryAccess;
import com.lishid.openinv.util.Permissions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record InventoryListener(OpenInv plugin) implements Listener
{
    @EventHandler
    private void onInventoryClose(@NotNull InventoryCloseEvent event) {
        ISpecialInventory specialInventory;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder holder = event.getInventory().getHolder();
        if (this.plugin.getSilentContainerStatus((OfflinePlayer)player) && holder != null && this.plugin.getAnySilentContainer().isAnySilentContainer(holder)) {
            this.plugin.getAnySilentContainer().deactivateContainer(player);
        }
        if ((specialInventory = InventoryAccess.getEnderChest(event.getInventory())) != null) {
            this.plugin.handleCloseInventory(specialInventory);
        } else {
            specialInventory = InventoryAccess.getPlayerInventory(event.getInventory());
            if (specialInventory != null) {
                this.plugin.handleCloseInventory(specialInventory);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onInventoryClick(@NotNull InventoryClickEvent event) {
        if (this.handleInventoryInteract((InventoryInteractEvent)event)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((Player)player).updateInventory());
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemStack clone = currentItem.clone();
        event.setCurrentItem(null);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            player.getInventory().addItem(new ItemStack[]{clone});
            player.updateInventory();
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onInventoryDrag(@NotNull InventoryDragEvent event) {
        if (this.handleInventoryInteract((InventoryInteractEvent)event)) {
            return;
        }
        InventoryView view = event.getView();
        int topSize = view.getTopInventory().getSize();
        Set slots = event.getRawSlots().stream().filter(slot -> slot >= topSize).map(slot -> this.plugin.convertToPlayerSlot(view, (int)slot)).collect(Collectors.toSet());
        int overlapLosses = 0;
        for (Map.Entry newItem : event.getNewItems().entrySet()) {
            int convertedSlot;
            int rawSlot = (Integer)newItem.getKey();
            if (rawSlot >= topSize || !slots.contains(convertedSlot = this.plugin.convertToPlayerSlot(view, rawSlot))) continue;
            overlapLosses += this.getCountDiff(view.getItem(rawSlot), (ItemStack)newItem.getValue());
        }
        if (overlapLosses < 1) {
            return;
        }
        ItemStack cursor = event.getCursor();
        if (cursor != null) {
            cursor.setAmount(cursor.getAmount() + overlapLosses);
        } else {
            cursor = event.getOldCursor().clone();
            cursor.setAmount(overlapLosses);
        }
        event.setCursor(cursor);
    }

    private int getCountDiff(@Nullable ItemStack original, @NotNull ItemStack result) {
        if (original == null || original.getType() != result.getType()) {
            return result.getAmount();
        }
        return result.getAmount() - original.getAmount();
    }

    private boolean handleInventoryInteract(@NotNull InventoryInteractEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (Permissions.SPECTATE.hasPermission((Permissible)entity) && entity.getGameMode() == GameMode.SPECTATOR) {
            event.setCancelled(false);
        }
        if (event.isCancelled()) {
            return true;
        }
        Inventory inventory = event.getView().getTopInventory();
        if (InventoryAccess.isEnderChest(inventory)) {
            if (!Permissions.EDITENDER.hasPermission((Permissible)entity)) {
                event.setCancelled(true);
            }
            return true;
        }
        ISpecialPlayerInventory playerInventory = InventoryAccess.getPlayerInventory(inventory);
        if (playerInventory == null) {
            return true;
        }
        if (!Permissions.EDITINV.hasPermission((Permissible)entity)) {
            event.setCancelled(true);
            return true;
        }
        return !event.getWhoClicked().equals((Object)playerInventory.getPlayer());
    }
}

