/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lishid.openinv.IOpenInv;
import com.lishid.openinv.InternalAccessor;
import com.lishid.openinv.InventoryListener;
import com.lishid.openinv.OfflineHandler;
import com.lishid.openinv.PlayerListener;
import com.lishid.openinv.commands.ContainerSettingCommand;
import com.lishid.openinv.commands.OpenInvCommand;
import com.lishid.openinv.commands.SearchContainerCommand;
import com.lishid.openinv.commands.SearchEnchantCommand;
import com.lishid.openinv.commands.SearchInvCommand;
import com.lishid.openinv.event.OpenPlayerSaveEvent;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.ConfigUpdater;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.StringMetric;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInv
extends JavaPlugin
implements IOpenInv {
    private final Cache<String, PlayerProfile> offlineLookUpCache = CacheBuilder.newBuilder().maximumSize(10L).build();
    private final Map<UUID, ISpecialPlayerInventory> inventories = new ConcurrentHashMap<UUID, ISpecialPlayerInventory>();
    private final Map<UUID, ISpecialEnderChest> enderChests = new ConcurrentHashMap<UUID, ISpecialEnderChest>();
    private InternalAccessor accessor;
    private LanguageManager languageManager;
    private boolean isSpigot = false;
    private OfflineHandler offlineHandler;

    public void reloadConfig() {
        super.reloadConfig();
        this.offlineHandler = this.disableOfflineAccess() ? OfflineHandler.REMOVE_AND_CLOSE : OfflineHandler.REQUIRE_PERMISSIONS;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        block3: {
            block2: {
                if (!this.isSpigot) break block2;
                if (this.accessor.isSupported()) break block3;
            }
            this.sendVersionError(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            return true;
        }
        return false;
    }

    public void onDisable() {
        if (this.disableSaving()) {
            return;
        }
        Stream.concat(this.inventories.values().stream(), this.enderChests.values().stream()).map(inventory -> {
            OpenInv.ejectViewers(inventory, viewer -> true);
            HumanEntity patt0$temp = inventory.getPlayer();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                return player;
            }
            return null;
        }).filter(Objects::nonNull).distinct().forEach(player -> {
            if (!player.isOnline()) {
                player = this.accessor.getPlayerDataManager().inject((Player)player);
            }
            player.saveData();
        });
    }

    public void onEnable() {
        this.saveDefaultConfig();
        PluginManager pm = this.getServer().getPluginManager();
        this.accessor = new InternalAccessor((Plugin)this);
        this.languageManager = new LanguageManager(this, "en_us");
        this.offlineHandler = this.disableOfflineAccess() ? OfflineHandler.REMOVE_AND_CLOSE : OfflineHandler.REQUIRE_PERMISSIONS;
        try {
            Class.forName("org.bukkit.entity.Player$Spigot");
            this.isSpigot = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.isSpigot = false;
        }
        if (this.isSpigot && this.accessor.isSupported()) {
            new ConfigUpdater(this).checkForUpdates();
            pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
            pm.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
            this.setCommandExecutor((CommandExecutor)new OpenInvCommand(this), "openinv", "openender");
            this.setCommandExecutor((CommandExecutor)new SearchContainerCommand(this), "searchcontainer");
            this.setCommandExecutor((CommandExecutor)new SearchInvCommand(this), "searchinv", "searchender");
            this.setCommandExecutor((CommandExecutor)new SearchEnchantCommand(this), "searchenchant");
            this.setCommandExecutor((CommandExecutor)new ContainerSettingCommand(this), "silentcontainer", "anycontainer");
        } else {
            this.sendVersionError(this.getLogger()::warning);
        }
    }

    private void setCommandExecutor(@NotNull CommandExecutor executor, String ... commands) {
        for (String commandName : commands) {
            PluginCommand command = this.getCommand(commandName);
            if (command == null) continue;
            command.setExecutor(executor);
        }
    }

    private void sendVersionError(@NotNull Consumer<String> messageMethod) {
        if (!this.accessor.isSupported()) {
            messageMethod.accept("Your server version (" + this.accessor.getVersion() + ") is not supported.");
            messageMethod.accept("Please download the correct version of OpenInv here: " + this.accessor.getReleasesLink());
        }
        if (!this.isSpigot) {
            messageMethod.accept("OpenInv requires that you use Spigot or a Spigot fork. Per the 1.14 update thread");
            messageMethod.accept("(https://www.spigotmc.org/threads/369724/ \"A Note on CraftBukkit\"), if you are");
            messageMethod.accept("encountering an inconsistency with vanilla that prevents you from using Spigot,");
            messageMethod.accept("that is considered a Spigot bug and should be reported as such.");
        }
    }

    @Override
    public boolean isSupportedVersion() {
        return this.accessor != null && this.accessor.isSupported();
    }

    @Override
    public boolean disableSaving() {
        return this.getConfig().getBoolean("settings.disable-saving", false);
    }

    @Override
    public boolean disableOfflineAccess() {
        return this.getConfig().getBoolean("settings.disable-offline-access", false);
    }

    @Override
    public boolean noArgsOpensSelf() {
        return this.getConfig().getBoolean("settings.command.open.no-args-opens-self", false);
    }

    @Override
    @NotNull
    public IAnySilentContainer getAnySilentContainer() {
        return this.accessor.getAnySilentContainer();
    }

    @Override
    public boolean getAnyContainerStatus(@NotNull OfflinePlayer offline) {
        Player onlinePlayer;
        boolean defaultState = false;
        if (offline.isOnline() && (onlinePlayer = offline.getPlayer()) != null) {
            defaultState = Permissions.ANY_DEFAULT.hasPermission((Permissible)onlinePlayer);
        }
        return this.getConfig().getBoolean("toggles.any-chest." + String.valueOf(offline.getUniqueId()), defaultState);
    }

    @Override
    public void setAnyContainerStatus(@NotNull OfflinePlayer offline, boolean status) {
        this.getConfig().set("toggles.any-chest." + String.valueOf(offline.getUniqueId()), (Object)status);
        this.saveConfig();
    }

    @Override
    public boolean getSilentContainerStatus(@NotNull OfflinePlayer offline) {
        Player onlinePlayer;
        boolean defaultState = false;
        if (offline.isOnline() && (onlinePlayer = offline.getPlayer()) != null) {
            defaultState = Permissions.SILENT_DEFAULT.hasPermission((Permissible)onlinePlayer);
        }
        return this.getConfig().getBoolean("toggles.silent-chest." + String.valueOf(offline.getUniqueId()), defaultState);
    }

    @Override
    public void setSilentContainerStatus(@NotNull OfflinePlayer offline, boolean status) {
        this.getConfig().set("toggles.silent-chest." + String.valueOf(offline.getUniqueId()), (Object)status);
        this.saveConfig();
    }

    @Override
    @NotNull
    public ISpecialEnderChest getSpecialEnderChest(@NotNull Player player, boolean online) throws InstantiationException {
        UUID key = player.getUniqueId();
        if (this.enderChests.containsKey(key)) {
            return this.enderChests.get(key);
        }
        ISpecialEnderChest inv = this.accessor.newSpecialEnderChest(player, online);
        this.enderChests.put(key, inv);
        return inv;
    }

    @Override
    @NotNull
    public ISpecialPlayerInventory getSpecialInventory(@NotNull Player player, boolean online) throws InstantiationException {
        UUID key = player.getUniqueId();
        if (this.inventories.containsKey(key)) {
            return this.inventories.get(key);
        }
        ISpecialPlayerInventory inv = this.accessor.newSpecialPlayerInventory(player, online);
        this.inventories.put(key, inv);
        return inv;
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull Player player, @NotNull ISpecialInventory inventory) {
        return this.accessor.getPlayerDataManager().openInventory(player, inventory);
    }

    @Override
    public boolean isPlayerLoaded(@NotNull UUID playerUuid) {
        return this.inventories.containsKey(playerUuid) || this.enderChests.containsKey(playerUuid);
    }

    @Override
    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        UUID key = offline.getUniqueId();
        if (this.inventories.containsKey(key)) {
            return (Player)this.inventories.get(key).getPlayer();
        }
        if (this.enderChests.containsKey(key)) {
            return (Player)this.enderChests.get(key).getPlayer();
        }
        Player player = offline.getPlayer();
        if (player != null) {
            return player;
        }
        if (this.disableOfflineAccess() || !this.isSupportedVersion()) {
            return null;
        }
        if (Bukkit.isPrimaryThread()) {
            return this.accessor.getPlayerDataManager().loadPlayer(offline);
        }
        Future future = Bukkit.getScheduler().callSyncMethod((Plugin)this, () -> this.accessor.getPlayerDataManager().loadPlayer(offline));
        try {
            player = (Player)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
        return player;
    }

    @Override
    @Nullable
    public OfflinePlayer matchPlayer(@NotNull String name) {
        if (Bukkit.getServer().isPrimaryThread()) {
            this.getLogger().warning("Call to OpenInv#matchPlayer made on the main thread!");
            this.getLogger().warning("This can cause the server to hang, potentially severely.");
            this.getLogger().log(Level.WARNING, "Current stack trace", new Throwable("Current stack trace"));
        }
        try {
            UUID uuid = UUID.fromString(name);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.hasPlayedBefore() || player.isOnline()) {
                return player;
            }
            return null;
        }
        catch (IllegalArgumentException uuid) {
            Player player = Bukkit.getServer().getPlayerExact(name);
            if (player != null) {
                return player;
            }
            PlayerProfile cachedResult = (PlayerProfile)this.offlineLookUpCache.getIfPresent((Object)name);
            if (cachedResult != null && cachedResult.getUniqueId() != null) {
                player = Bukkit.getOfflinePlayer((UUID)cachedResult.getUniqueId());
                if (player.hasPlayedBefore() || player.isOnline()) {
                    return player;
                }
                return null;
            }
            player = Bukkit.getServer().getOfflinePlayer(name);
            if (player.hasPlayedBefore()) {
                this.offlineLookUpCache.put((Object)name, (Object)player.getPlayerProfile());
                return player;
            }
            player = Bukkit.getServer().getPlayer(name);
            if (player != null) {
                return player;
            }
            float bestMatch = 0.0f;
            for (OfflinePlayer offline : Bukkit.getServer().getOfflinePlayers()) {
                if (offline.getName() == null) continue;
                float currentMatch = StringMetric.compareJaroWinkler(name, offline.getName());
                if (currentMatch == 1.0f) {
                    return offline;
                }
                if (!(currentMatch > bestMatch)) continue;
                bestMatch = currentMatch;
                player = offline;
            }
            if (player != null) {
                this.offlineLookUpCache.put((Object)name, (Object)player.getPlayerProfile());
                return player;
            }
            return null;
        }
    }

    @Override
    public void unload(@NotNull OfflinePlayer offline) {
        this.setPlayerOffline(offline, OfflineHandler.REMOVE_AND_CLOSE);
    }

    void changeWorld(@NotNull Player player) {
        UUID key = player.getUniqueId();
        if (this.inventories.containsKey(key)) {
            this.kickCrossWorldViewers(player, this.inventories.get(key));
        }
        if (this.enderChests.containsKey(key)) {
            this.kickCrossWorldViewers(player, this.enderChests.get(key));
        }
    }

    private void kickCrossWorldViewers(@NotNull Player player, @NotNull ISpecialInventory inventory) {
        OpenInv.ejectViewers(inventory, viewer -> !Permissions.CROSSWORLD.hasPermission((Permissible)viewer) && !Objects.equals(viewer.getWorld(), player.getWorld()));
    }

    int convertToPlayerSlot(InventoryView view, int rawSlot) {
        return this.accessor.getPlayerDataManager().convertToPlayerSlot(view, rawSlot);
    }

    @Nullable
    public String getLocalizedMessage(@NotNull CommandSender sender, @NotNull String key) {
        return this.languageManager.getValue(key, this.getLocale(sender));
    }

    @Nullable
    public String getLocalizedMessage(@NotNull CommandSender sender, @NotNull String key, Replacement ... replacements) {
        return this.languageManager.getValue(key, this.getLocale(sender), replacements);
    }

    @NotNull
    private String getLocale(@NotNull CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getLocale();
        }
        return this.getConfig().getString("settings.locale", "en_us");
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull String key) {
        String message = this.getLocalizedMessage(sender, key);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull String key, Replacement ... replacements) {
        String message = this.getLocalizedMessage(sender, key, replacements);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void sendSystemMessage(@NotNull Player player, @NotNull String key) {
        String message = this.getLocalizedMessage((CommandSender)player, key);
        if (message == null) {
            return;
        }
        int newline = message.indexOf(10);
        if (newline != -1) {
            message = message.substring(0, newline);
        }
        if (message.isEmpty()) {
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    void setPlayerOffline(@NotNull Player player) {
        this.setPlayerOffline((OfflinePlayer)player, this.offlineHandler);
    }

    private void setPlayerOffline(@NotNull OfflinePlayer player, @NotNull OfflineHandler handler) {
        UUID key = player.getUniqueId();
        this.setPlayerOffline(this.inventories, key, handler);
        this.setPlayerOffline(this.enderChests, key, handler);
    }

    private void setPlayerOffline(@NotNull Map<UUID, ? extends ISpecialInventory> map, @NotNull UUID key, @NotNull OfflineHandler handler) {
        ISpecialInventory inventory = handler.fetch().apply(map, key);
        if (inventory == null) {
            return;
        }
        inventory.setPlayerOffline();
        if (!inventory.isInUse()) {
            map.remove(key);
        } else {
            handler.handle().accept(inventory);
        }
    }

    void handleCloseInventory(@NotNull ISpecialInventory inventory) {
        UUID key;
        Map<UUID, ISpecialInventory> map = inventory instanceof ISpecialPlayerInventory ? this.inventories : this.enderChests;
        @Nullable ISpecialInventory loaded = map.get(key = inventory.getPlayer().getUniqueId());
        if (loaded == null) {
            return;
        }
        if (loaded != inventory) {
            Inventory bukkitInventory = inventory.getBukkitInventory();
            loaded.getBukkitInventory().setContents(bukkitInventory.getContents());
            if (inventory.isInUse()) {
                this.getServer().getScheduler().runTask((Plugin)this, () -> OpenInv.ejectViewers(inventory, viewer -> true));
            }
        }
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            Player player;
            HumanEntity patt0$temp;
            if (loaded.isInUse()) {
                return;
            }
            ISpecialInventory current = (ISpecialInventory)map.remove(key);
            if (this.disableSaving() || current == null || !((patt0$temp = current.getPlayer()) instanceof Player) || (player = (Player)patt0$temp).isOnline()) {
                return;
            }
            OpenPlayerSaveEvent event = new OpenPlayerSaveEvent(player, current);
            this.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.accessor.getPlayerDataManager().inject(player).saveData();
            }
        });
    }

    void setPlayerOnline(@NotNull Player player) {
        this.setPlayerOnline(this.inventories, player, () -> ((Player)player).updateInventory());
        this.setPlayerOnline(this.enderChests, player, null);
        if (player.hasPlayedBefore()) {
            return;
        }
        String name = player.getName();
        this.offlineLookUpCache.invalidate((Object)name);
        if (this.offlineLookUpCache.size() == 0L) {
            return;
        }
        this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            Iterator iterator = this.offlineLookUpCache.asMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String oldMatch = ((PlayerProfile)entry.getValue()).getName();
                if (oldMatch == null) {
                    iterator.remove();
                    continue;
                }
                String lookup = (String)entry.getKey();
                float oldMatchScore = StringMetric.compareJaroWinkler(lookup, oldMatch);
                float newMatchScore = StringMetric.compareJaroWinkler(lookup, name);
                if (!(newMatchScore > oldMatchScore)) continue;
                iterator.remove();
            }
        }, 101L);
    }

    private void setPlayerOnline(@NotNull Map<UUID, ? extends ISpecialInventory> map, @NotNull Player player, @Nullable Runnable task) {
        ISpecialInventory inventory = map.get(player.getUniqueId());
        if (inventory == null) {
            return;
        }
        inventory.setPlayerOnline(player);
        OpenInv.ejectViewers(inventory, viewer -> !Permissions.OPENONLINE.hasPermission((Permissible)viewer) || !Permissions.CROSSWORLD.hasPermission((Permissible)viewer) && !Objects.equals(viewer.getWorld(), inventory.getPlayer().getWorld()));
        if (task != null) {
            this.getServer().getScheduler().runTask((Plugin)this, task);
        }
    }

    static void ejectViewers(@NotNull ISpecialInventory inventory, @NotNull @NotNull Predicate<@NotNull HumanEntity> predicate) {
        Inventory bukkitInventory = inventory.getBukkitInventory();
        for (HumanEntity viewer : new ArrayList(bukkitInventory.getViewers())) {
            if (viewer.getUniqueId().equals(inventory.getPlayer().getUniqueId()) && !viewer.getOpenInventory().getTopInventory().equals((Object)bukkitInventory) || !predicate.test(viewer)) continue;
            viewer.closeInventory();
        }
    }
}

