/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class SearchContainerCommand
implements TabExecutor {
    private final OpenInv plugin;

    public SearchContainerCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, "messages.error.consoleUnsupported");
            return true;
        }
        Player senderPlayer = (Player)sender;
        if (args.length < 1) {
            return false;
        }
        Material material = Material.getMaterial((String)args[0].toUpperCase());
        if (material == null) {
            this.plugin.sendMessage(sender, "messages.error.invalidMaterial", new Replacement("%target%", args[0]));
            return false;
        }
        int radius = 5;
        if (args.length > 1) {
            try {
                radius = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        int configMax = this.plugin.getConfig().getInt("settings.command.searchcontainer.max-radius", 10);
        radius = Math.max(0, Math.min(radius, configMax));
        World world = senderPlayer.getWorld();
        Chunk centerChunk = senderPlayer.getLocation().getChunk();
        StringBuilder locations = new StringBuilder();
        for (int dX = -radius; dX <= radius; ++dX) {
            for (int dZ = -radius; dZ <= radius; ++dZ) {
                if (!world.loadChunk(centerChunk.getX() + dX, centerChunk.getZ() + dZ, false)) continue;
                Chunk chunk = world.getChunkAt(centerChunk.getX() + dX, centerChunk.getZ() + dZ);
                for (BlockState tileEntity : chunk.getTileEntities()) {
                    InventoryHolder holder;
                    if (!(tileEntity instanceof InventoryHolder) || !(holder = (InventoryHolder)tileEntity).getInventory().contains(material)) continue;
                    locations.append(holder.getInventory().getType().name().toLowerCase()).append(" (").append(tileEntity.getX()).append(',').append(tileEntity.getY()).append(',').append(tileEntity.getZ()).append("), ");
                }
            }
        }
        if (locations.length() <= 0) {
            this.plugin.sendMessage(sender, "messages.info.container.noMatches", new Replacement("%target%", material.name()));
            return true;
        }
        locations.delete(locations.length() - 2, locations.length());
        this.plugin.sendMessage(sender, "messages.info.container.matches", new Replacement("%target%", material.name()), new Replacement("%detail%", locations.toString()));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length < 1 || args.length > 2 || !command.testPermissionSilent(sender)) {
            return Collections.emptyList();
        }
        String argument = args[args.length - 1];
        if (args.length == 1) {
            return TabCompleter.completeEnum(argument, Material.class);
        }
        return TabCompleter.completeInteger(argument);
    }
}

