/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R4;

import com.lishid.openinv.internal.AnySilentContainerBase;
import com.lishid.openinv.internal.v1_20_R4.PlayerManager;
import com.lishid.openinv.util.ReflectionHelper;
import com.lishid.openinv.util.lang.LanguageManager;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
extends AnySilentContainerBase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LanguageManager lang;
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.lang = lang;
        try {
            try {
                this.serverPlayerGameModeGameType = arh.class.getDeclaredField("b");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.warning("ServerPlayerGameMode#gameModeForPlayer's obfuscated name has changed!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(arh.class, dbx.class);
            }
        }
        catch (SecurityException e) {
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull Block bukkitBlock) {
        iz blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        arg player = PlayerManager.getHandle(bukkitPlayer);
        dca level = player.dP();
        dpj blockEntity = level.c_(blockPos = new iz(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof dqe) {
            dqe enderChestTile = (dqe)blockEntity;
            cri enderChest = player.gp();
            enderChest.a(enderChestTile);
            player.a((bra)new brg((containerCounter, playerInventory, ignored) -> {
                crd<?> containers = PlayerManager.getContainers(enderChest.b());
                int rows = enderChest.b() / 9;
                return new cqd(containers, containerCounter, playerInventory, (bqp)enderChest, rows);
            }, (xp)xp.c((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof bra)) {
            return false;
        }
        bra menuProvider = (bra)blockEntity;
        dse blockState = level.a_(blockPos);
        dfb block = blockState.b();
        if (block instanceof dge) {
            dge chestBlock = (dge)block;
            menuProvider = chestBlock.getMenuProvider(blockState, level, blockPos, true);
            if (menuProvider == null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof dnp) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof dma) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof deh) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.e.b() == dbx.d) {
            player.a(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof dqo) {
            dqo lootable = (dqo)blockEntity;
            if (lootable.l != null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        dbx gameType = player.e.b();
        this.forceGameType(player, dbx.d);
        player.a(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        arg player = PlayerManager.getHandle(bukkitPlayer);
        dbx gameType = player.e.b();
        this.forceGameType(player, dbx.d);
        player.cb.transferTo((cpw)player.ca, (CraftHumanEntity)player.getBukkitEntity());
        player.s();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(arg player, dbx gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.e, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.log(Level.WARNING, "Error bypassing GameModeChangeEvent", e);
        }
    }
}

