/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R4;

import com.lishid.openinv.event.OpenEvents;
import com.lishid.openinv.internal.v1_20_R4.PlayerManager;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayer
extends CraftPlayer {
    private static final Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "Passengers", "warden_spawn_tracker", "enteredNetherPosition", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "raid_omen_position", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "current_explosion_impact_pos", "ActiveEffects", "active_effects", "SleepingX", "SleepingY", "SleepingZ", "Brain");
    private final PlayerManager manager;

    OpenPlayer(CraftServer server, arg entity, PlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData(this.getHandle());
    }

    public void saveData() {
        if (OpenEvents.saveCancelled((Player)this)) {
            return;
        }
        arg player = this.getHandle();
        try {
            eqb worldNBTStorage = player.d.ah().t;
            us oldData = this.isOnline() ? null : (us)worldNBTStorage.load(player.af().getString(), player.cA()).orElse(null);
            us playerData = this.getWritableTag(oldData);
            playerData = player.f(playerData);
            this.setExtraData(playerData);
            if (oldData != null) {
                this.revertSpecialValues(playerData, oldData);
            }
            Path playerDataDir = worldNBTStorage.getPlayerDir().toPath();
            Path tempFile = Files.createTempFile(playerDataDir, player.cA() + "-", ".dat", new FileAttribute[0]);
            vf.a((us)playerData, (Path)tempFile);
            Path dataFile = playerDataDir.resolve(player.cA() + ".dat");
            Path backupFile = playerDataDir.resolve(player.cA() + ".dat_old");
            ac.a((Path)dataFile, (Path)tempFile, (Path)backupFile);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.cB(), (Object)e);
        }
    }

    @Contract(value="null -> new")
    @NotNull
    private us getWritableTag(@Nullable us oldData) {
        if (oldData == null) {
            return new us();
        }
        oldData = oldData.i();
        oldData.e().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit"));
        return oldData;
    }

    private void revertSpecialValues(@NotNull us newData, @NotNull us oldData) {
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", vi.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", vi.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", vi.class);
    }

    private <T extends vp> void copyValue(@NotNull us source, @NotNull us target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        us oldContainer = this.getTag(source, container, us.class);
        us newContainer = this.getTag(target, container, us.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends vp> T getTag(@Nullable us container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        vp value = container.c(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((vp)dataType.cast(value));
    }

    private <T extends vp> void setTag(@NotNull us container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            container.r(key);
        } else {
            container.a(key, data);
        }
    }
}

