/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R4;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.InventoryViewTitle;
import com.lishid.openinv.internal.OpenInventoryView;
import com.lishid.openinv.internal.v1_20_R4.OpenPlayer;
import com.lishid.openinv.util.lang.LanguageManager;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftContainer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager
implements com.lishid.openinv.internal.PlayerManager {
    private static boolean paper;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LanguageManager lang;
    @Nullable
    private Field bukkitEntity;

    public PlayerManager(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.lang = lang;
        try {
            this.bukkitEntity = bsw.class.getDeclaredField("bukkitEntity");
        }
        catch (NoSuchFieldException e) {
            logger.warning("Unable to obtain field to inject custom save process - certain player data may be lost when saving!");
            logger.log(Level.WARNING, e.getMessage(), e);
            this.bukkitEntity = null;
        }
    }

    @NotNull
    public static arg getHandle(Player player) {
        if (player instanceof CraftPlayer) {
            return ((CraftPlayer)player).getHandle();
        }
        Server server = player.getServer();
        arg nmsPlayer = null;
        if (server instanceof CraftServer) {
            nmsPlayer = ((CraftServer)server).getHandle().a(player.getUniqueId());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from Player implementation " + player.getClass().getName());
        }
        return nmsPlayer;
    }

    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        aqb server = ((CraftServer)Bukkit.getServer()).getServer();
        arf worldServer = server.a(dca.h);
        if (worldServer == null) {
            return null;
        }
        arg entity = this.createNewPlayer((MinecraftServer)server, worldServer, offline);
        entity.Q().a();
        if (this.loadData(entity)) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @NotNull
    private arg createNewPlayer(@NotNull MinecraftServer server, @NotNull arf worldServer, @NotNull OfflinePlayer offline) {
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        aqu dummyInfo = new aqu("en_us", 1, cmx.c, false, 0, arg.bF, true, false);
        arg entity = new arg(server, worldServer, profile, dummyInfo);
        try {
            this.injectPlayer(entity);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
        }
        return entity;
    }

    boolean loadData(@NotNull arg player) {
        us loadedData = player.d.ah().t.b((cmz)player).orElse(null);
        if (loadedData == null) {
            return false;
        }
        player.g(loadedData);
        player.a(loadedData);
        player.c(loadedData);
        if (paper) {
            this.parseWorld(player, loadedData);
        }
        return true;
    }

    private void parseWorld(@NotNull arg player, @NotNull us loadedData) {
        World bukkitWorld;
        if (loadedData.e("WorldUUIDMost") && loadedData.e("WorldUUIDLeast")) {
            bukkitWorld = Bukkit.getServer().getWorld(new UUID(loadedData.i("WorldUUIDMost"), loadedData.i("WorldUUIDLeast")));
        } else if (loadedData.b("world", 8)) {
            bukkitWorld = Bukkit.getServer().getWorld(loadedData.l("world"));
        } else {
            dvw.a((Dynamic)new Dynamic((DynamicOps)vg.a, (Object)loadedData.c("Dimension"))).resultOrPartial(this.logger::warning).map(arg_0 -> ((MinecraftServer)player.d).a(arg_0)).ifPresentOrElse(arg_0 -> ((arg)player).c(arg_0), () -> player.spawnIn(null));
            return;
        }
        if (bukkitWorld == null) {
            player.spawnIn(null);
            return;
        }
        player.c(((CraftWorld)bukkitWorld).getHandle());
    }

    private void injectPlayer(arg player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.d.server, player, this));
    }

    @NotNull
    public Player inject(@NotNull Player player) {
        try {
            arg nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof OpenPlayer) {
                OpenPlayer openPlayer = (OpenPlayer)craftPlayer;
                return openPlayer;
            }
            this.injectPlayer(nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Nullable
    public InventoryView openInventory(@NotNull Player player, final @NotNull ISpecialInventory inventory, boolean viewOnly) {
        arg nmsPlayer = PlayerManager.getHandle(player);
        if (nmsPlayer.c == null) {
            return null;
        }
        InventoryViewTitle title = InventoryViewTitle.of((ISpecialInventory)inventory);
        if (title == null) {
            return player.openInventory(inventory.getBukkitInventory());
        }
        OpenInventoryView view = new OpenInventoryView(player, inventory, title.getTitle(this.lang, player, inventory));
        CraftContainer container = new CraftContainer(this, (InventoryView)view, (cmz)nmsPlayer, nmsPlayer.nextContainerCounter()){

            public crd<?> a() {
                return PlayerManager.getContainers(inventory.getBukkitInventory().getSize());
            }
        };
        container.setTitle((xp)xp.b((String)view.getOriginalTitle()));
        container = CraftEventFactory.callInventoryOpenEvent((arg)nmsPlayer, (cpw)container);
        if (container == null) {
            return null;
        }
        nmsPlayer.c.b((zw)new aef(container.j, container.a(), (xp)xp.b((String)container.getBukkitView().getTitle())));
        nmsPlayer.cb = container;
        nmsPlayer.a((cpw)container);
        return container.getBukkitView();
    }

    @NotNull
    static crd<?> getContainers(int inventorySize) {
        return switch (inventorySize) {
            case 9 -> crd.a;
            case 18 -> crd.b;
            case 36 -> crd.d;
            case 41, 45 -> crd.e;
            case 54 -> crd.f;
            default -> crd.c;
        };
    }

    static {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
            paper = true;
        }
        catch (ClassNotFoundException ignored) {
            paper = false;
        }
    }
}

