/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container;

import com.lishid.openinv.internal.AnySilentContainerBase;
import com.lishid.openinv.internal.v1_21_R1.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.v1_21_R1.player.PlayerManager;
import com.lishid.openinv.util.ReflectionHelper;
import com.lishid.openinv.util.lang.LanguageManager;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySilentContainer
extends AnySilentContainerBase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LanguageManager lang;
    @Nullable
    private Field serverPlayerGameModeGameType;

    public AnySilentContainer(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.lang = lang;
        try {
            try {
                this.serverPlayerGameModeGameType = aqw.class.getDeclaredField("b");
                this.serverPlayerGameModeGameType.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.warning("ServerPlayerGameMode#gameModeForPlayer's obfuscated name has changed!");
                logger.warning("Please report this at https://github.com/Jikoo/OpenInv/issues");
                logger.warning("Attempting to fall through using reflection. Please verify that SilentContainer does not fail.");
                this.serverPlayerGameModeGameType = ReflectionHelper.grabFieldByType(aqw.class, dct.class);
            }
        }
        catch (SecurityException e) {
            logger.warning("Unable to directly write player game mode! SilentContainer will fail.");
            logger.log(Level.WARNING, "Error obtaining GameType field", e);
        }
    }

    public boolean activateContainer(@NotNull Player bukkitPlayer, boolean silentchest, @NotNull Block bukkitBlock) {
        jd blockPos;
        if (silentchest && bukkitBlock.getType() == Material.ENDER_CHEST) {
            bukkitPlayer.openInventory(bukkitPlayer.getEnderChest());
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        aqv player = PlayerManager.getHandle(bukkitPlayer);
        dcw level = player.dO();
        dqh blockEntity = level.c_(blockPos = new jd(bukkitBlock.getX(), bukkitBlock.getY(), bukkitBlock.getZ()));
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof drd) {
            drd enderChestTile = (drd)blockEntity;
            crh enderChest = player.gl();
            enderChest.a(enderChestTile);
            player.a((bqv)new brb((containerCounter, playerInventory, ignored) -> {
                crc<cqc> containers = OpenChestMenu.getChestMenuType(enderChest.b());
                int rows = enderChest.b() / 9;
                return new cqc(containers, containerCounter, playerInventory, (bqk)enderChest, rows);
            }, (wz)wz.c((String)"container.enderchest")));
            bukkitPlayer.incrementStatistic(Statistic.ENDERCHEST_OPENED);
            return true;
        }
        if (!(blockEntity instanceof bqv)) {
            return false;
        }
        bqv menuProvider = (bqv)blockEntity;
        dtc blockState = level.a_(blockPos);
        dfy block = blockState.b();
        if (block instanceof dhb) {
            dhb chestBlock = (dhb)block;
            menuProvider = chestBlock.getMenuProvider(blockState, level, blockPos, true);
            if (menuProvider == null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
            if (block instanceof don) {
                bukkitPlayer.incrementStatistic(Statistic.TRAPPED_CHEST_TRIGGERED);
            } else {
                bukkitPlayer.incrementStatistic(Statistic.CHEST_OPENED);
            }
        }
        if (block instanceof dmy) {
            bukkitPlayer.incrementStatistic(Statistic.SHULKER_BOX_OPENED);
        }
        if (block instanceof dfe) {
            bukkitPlayer.incrementStatistic(Statistic.OPEN_BARREL);
        }
        if (!silentchest || player.e.b() == dct.d) {
            player.a(menuProvider);
            return true;
        }
        if (this.serverPlayerGameModeGameType == null) {
            return false;
        }
        if (blockEntity instanceof drn) {
            drn lootable = (drn)blockEntity;
            if (lootable.l != null) {
                this.lang.sendSystemMessage(bukkitPlayer, "messages.error.lootNotGenerated");
                return false;
            }
        }
        dct gameType = player.e.b();
        this.forceGameType(player, dct.d);
        player.a(menuProvider);
        this.forceGameType(player, gameType);
        return true;
    }

    public void deactivateContainer(@NotNull Player bukkitPlayer) {
        if (this.serverPlayerGameModeGameType == null || bukkitPlayer.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        aqv player = PlayerManager.getHandle(bukkitPlayer);
        dct gameType = player.e.b();
        this.forceGameType(player, dct.d);
        player.cd.transferTo((cpu)player.cc, (CraftHumanEntity)player.getBukkitEntity());
        player.t();
        this.forceGameType(player, gameType);
    }

    private void forceGameType(aqv player, dct gameMode) {
        if (this.serverPlayerGameModeGameType == null) {
            return;
        }
        try {
            this.serverPlayerGameModeGameType.setAccessible(true);
            this.serverPlayerGameModeGameType.set(player.e, gameMode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.log(Level.WARNING, "Error bypassing GameModeChangeEvent", e);
        }
    }
}

