/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container;

import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.v1_21_R1.container.Placeholders;
import com.lishid.openinv.internal.v1_21_R1.container.bukkit.OpenPlayerInventory;
import com.lishid.openinv.internal.v1_21_R1.container.menu.OpenInventoryMenu;
import com.lishid.openinv.internal.v1_21_R1.container.slot.Content;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentCrafting;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentCraftingResult;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentCursor;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentDrop;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentEquipment;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentList;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentOffHand;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentViewOnly;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotViewOnly;
import com.lishid.openinv.internal.v1_21_R1.player.PlayerManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventory
implements bqk,
InternalOwned<aqv>,
ISpecialPlayerInventory {
    private final List<Content> slots;
    private final int size;
    private aqv owner;
    private int maxStackSize = 99;
    private CraftInventory bukkitEntity;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    public OpenInventory(@NotNull Player bukkitPlayer) {
        this.owner = PlayerManager.getHandle(bukkitPlayer);
        int rawSize = this.owner.fY().b() + this.owner.cc.r().b() + 1;
        this.size = (int)Math.ceil((double)rawSize / 9.0) * 9;
        this.slots = jv.a((int)this.size, (Object)new ContentViewOnly(this.owner));
        this.setupSlots();
    }

    private void setupSlots() {
        int nextIndex = this.addMainInventory();
        cmw ownerInv = this.owner.fY();
        if (ownerInv.h.size() == 36 && ownerInv.i.size() == 4 && ownerInv.j.size() == 1 && this.owner.cc.r().b() == 4) {
            this.addArmor(36);
            this.addOffHand(46);
            this.slots.set(53, new ContentDrop(this.owner));
            this.slots.set(44, new ContentCursor(this.owner));
            this.addCrafting(41, true);
            return;
        }
        nextIndex = this.addArmor(nextIndex);
        nextIndex = this.addOffHand(nextIndex);
        nextIndex = this.addCrafting(nextIndex, false);
        this.slots.set(nextIndex, new ContentCursor(this.owner));
        this.slots.set(this.slots.size() - 1, new ContentDrop(this.owner));
    }

    private int addMainInventory() {
        int listSize = this.owner.fY().h.size();
        int hotbarDiff = listSize - 9;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            InventoryType.SlotType type;
            int invIndex;
            if (localIndex < hotbarDiff) {
                invIndex = localIndex + 9;
                type = InventoryType.SlotType.CONTAINER;
            } else {
                type = InventoryType.SlotType.QUICKBAR;
                invIndex = localIndex - hotbarDiff;
            }
            this.slots.set(localIndex, new ContentList(this, this.owner, invIndex, type){

                @Override
                public void setHolder(@NotNull aqv holder) {
                    this.items = holder.fY().h;
                }
            });
        }
        return listSize;
    }

    private int addArmor(int startIndex) {
        int listSize = this.owner.fY().i.size();
        for (int i = 0; i < listSize; ++i) {
            int armorIndex;
            this.slots.set(startIndex + i, new ContentEquipment(this.owner, armorIndex, switch (i) {
                case 3 -> {
                    armorIndex = 0;
                    yield bsy.c;
                }
                case 2 -> {
                    armorIndex = 1;
                    yield bsy.d;
                }
                case 1 -> {
                    armorIndex = 2;
                    yield bsy.e;
                }
                case 0 -> {
                    armorIndex = 3;
                    yield bsy.f;
                }
                default -> {
                    armorIndex = i;
                    yield bsy.a;
                }
            }));
        }
        return startIndex + listSize;
    }

    private int addOffHand(int startIndex) {
        int listSize = this.owner.fY().j.size();
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            this.slots.set(startIndex + localIndex, new ContentOffHand(this.owner, localIndex));
        }
        return startIndex + listSize;
    }

    private int addCrafting(int startIndex, boolean pretty) {
        int listSize = this.owner.cc.r().getContents().size();
        pretty &= listSize == 4;
        for (int localIndex = 0; localIndex < listSize; ++localIndex) {
            int modIndex = startIndex + (localIndex < 2 || !pretty ? localIndex : localIndex + 7);
            this.slots.set(modIndex, new ContentCrafting(this.owner, localIndex));
        }
        if (pretty) {
            this.slots.set(startIndex + 2, new ContentViewOnly(this, this.owner){

                @Override
                public crq asSlot(bqk container, int slot, int x, int y) {
                    return new SlotViewOnly(this, container, slot, x, y){

                        @Override
                        public cuq getOrDefault() {
                            return Placeholders.craftingOutput;
                        }
                    };
                }
            });
            this.slots.set(startIndex + 11, new ContentCraftingResult(this.owner));
        }
        return startIndex + listSize;
    }

    public crq getMenuSlot(int index, int x, int y) {
        return this.slots.get(index).asSlot(this, index, x, y);
    }

    public InventoryType.SlotType getSlotType(int index) {
        return this.slots.get(index).getSlotType();
    }

    @NotNull
    public wz getTitle(@Nullable aqv viewer) {
        xn component = wz.i();
        if (this.owner.equals((Object)viewer)) {
            component.b((wz)wz.a((String)"openinv.container.inventory.self", (String)"").a(style -> style.a(akr.a((String)"openinv:font/inventory")).a(n.p)));
        } else {
            component.b((wz)wz.a((String)"openinv.container.inventory.other", (String)"").a(style -> style.a(akr.a((String)"openinv:font/inventory")).a(n.p)));
        }
        component.b((wz)wz.a((String)"openinv.container.inventory.prefix", (String)"", (Object[])new Object[]{this.owner.ah()})).b((wz)wz.c((String)"container.inventory")).b((wz)wz.a((String)"openinv.container.inventory.suffix", (String)" - %s", (Object[])new Object[]{this.owner.ah()}));
        return component;
    }

    public aqv getOwnerHandle() {
        return this.owner;
    }

    @NotNull
    public Inventory getBukkitInventory() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new OpenPlayerInventory(this);
        }
        return this.bukkitEntity;
    }

    public void setPlayerOnline(@NotNull Player player) {
        aqv newOwner = PlayerManager.getHandle(player);
        newOwner.fY().a(this.owner.fY());
        this.owner = newOwner;
        this.slots.forEach(slot -> slot.setHolder(newOwner));
    }

    public void setPlayerOffline() {
    }

    public boolean isInUse() {
        return !this.transaction.isEmpty();
    }

    @NotNull
    public Player getPlayer() {
        return this.getOwner();
    }

    public int b() {
        return this.size;
    }

    public boolean c() {
        return this.slots.stream().map(Content::get).allMatch(cuq::e);
    }

    public cuq a(int index) {
        return this.slots.get(index).get();
    }

    public cuq a(int index, int amount) {
        return this.slots.get(index).removePartial(amount);
    }

    public cuq b(int index) {
        return this.slots.get(index).remove();
    }

    public void a(int index, cuq itemStack) {
        this.slots.get(index).set(itemStack);
    }

    public int al_() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void e() {
    }

    public boolean a(cmx player) {
        return true;
    }

    public List<cuq> getContents() {
        jv contents = jv.a((int)this.b(), (Object)cuq.l);
        for (int i = 0; i < this.b(); ++i) {
            contents.set(i, (Object)this.a(i));
        }
        return contents;
    }

    public void onOpen(CraftHumanEntity viewer) {
        this.transaction.add((HumanEntity)viewer);
    }

    public void onClose(CraftHumanEntity viewer) {
        this.transaction.remove(viewer);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public Player getOwner() {
        return this.owner.getBukkitEntity();
    }

    public Location getLocation() {
        return this.owner.getBukkitEntity().getLocation();
    }

    public void a() {
        this.owner.fY().a();
        this.owner.cc.r().a();
        this.owner.cc.a((bqk)this.owner.cc.r());
        this.owner.cd.b(cuq.l);
    }

    @Nullable
    public cpu createMenu(cmx player, int i, boolean viewOnly) {
        if (player instanceof aqv) {
            aqv serverPlayer = (aqv)player;
            return new OpenInventoryMenu(this, serverPlayer, i, viewOnly);
        }
        return null;
    }
}

