/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.v1_21_R1.container.bukkit.OpenDummyInventory;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotViewOnly;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenChestMenu<T extends bqk & ISpecialInventory>
extends cpu {
    protected static final int BOTTOM_INVENTORY_SIZE = 36;
    protected final T container;
    protected final aqv viewer;
    protected final boolean viewOnly;
    protected final boolean ownContainer;
    protected final int topSize;
    private CraftInventoryView<OpenChestMenu<T>> bukkitEntity;
    @Nullable
    private cqi synchronizer;
    private final List<cqn> dataSlots = new ArrayList<cqn>();
    private final IntList remoteDataSlots = new IntArrayList();
    private final List<cqh> containerListeners = new ArrayList<cqh>();
    private cuq remoteCarried = cuq.l;
    private boolean suppressRemoteUpdates;

    protected OpenChestMenu(@NotNull crc<cqc> type, int containerCounter, @NotNull T container, @NotNull aqv viewer, boolean viewOnly) {
        super(type, containerCounter);
        int y;
        int x;
        int col;
        this.container = container;
        this.viewer = viewer;
        this.viewOnly = viewOnly;
        this.ownContainer = ((aqv)((InternalOwned)container).getOwnerHandle()).equals((Object)viewer);
        this.topSize = this.getTopSize(viewer);
        this.preSlotSetup();
        int upperRows = this.topSize / 9;
        for (int row = 0; row < upperRows; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                y = 18 + row * 18;
                int index = row * 9 + col;
                if (index >= container.b()) {
                    this.a(new SlotViewOnly((bqk)container, index, x, y));
                    continue;
                }
                crq slot = this.getUpperSlot(index, x, y);
                this.a(slot);
            }
        }
        int playerInvPad = (upperRows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int x2 = 8 + col2 * 18;
                int y2 = playerInvPad + row * 18 + 103;
                this.a(new crq((bqk)viewer.fY(), row * 9 + col2 + 9, x2, y2));
            }
        }
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = playerInvPad + 161;
            this.a(new crq((bqk)viewer.fY(), col, x, y));
        }
    }

    @NotNull
    public static crc<cqc> getChestMenuType(int inventorySize) {
        inventorySize = (int)Math.ceil((double)inventorySize / 9.0) * 9;
        return switch (inventorySize) {
            case 9 -> crc.a;
            case 18 -> crc.b;
            case 27 -> crc.c;
            case 36 -> crc.d;
            case 45 -> crc.e;
            case 54 -> crc.f;
            default -> throw new IllegalArgumentException("Inventory size unsupported: " + inventorySize);
        };
    }

    protected void preSlotSetup() {
    }

    @NotNull
    protected crq getUpperSlot(int index, int x, int y) {
        if (this.viewOnly) {
            return new SlotViewOnly((bqk)this.container, index, x, y);
        }
        return new crq(this.container, index, x, y);
    }

    @NotNull
    public final CraftInventoryView<OpenChestMenu<T>> getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = this.createBukkitEntity();
        }
        return this.bukkitEntity;
    }

    @NotNull
    protected CraftInventoryView<OpenChestMenu<T>> createBukkitEntity() {
        Object top = this.viewOnly ? new OpenDummyInventory((bqk)this.container) : ((ISpecialInventory)this.container).getBukkitInventory();
        return new CraftInventoryView<OpenChestMenu<T>>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)top, this){

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return null;
                }
                return super.getInventory(rawSlot);
            }

            public int convertSlot(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return -999;
                }
                return super.convertSlot(rawSlot);
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenChestMenu.this.viewOnly) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                return super.getSlotType(slot);
            }
        };
    }

    private int getTopSize(aqv viewer) {
        crc menuType = this.a();
        if (menuType == null) {
            throw new IllegalStateException("MenuType cannot be null!");
        }
        if (menuType == crc.a) {
            return 9;
        }
        if (menuType == crc.b) {
            return 18;
        }
        if (menuType == crc.c) {
            return 27;
        }
        if (menuType == crc.d) {
            return 36;
        }
        if (menuType == crc.e) {
            return 45;
        }
        if (menuType == crc.f) {
            return 54;
        }
        return menuType.a((int)-1, (cmw)viewer.fY()).i.size() - 36;
    }

    protected boolean a(cuq itemStack, int rangeLow, int rangeHigh, boolean topDown) {
        int index;
        boolean modified = false;
        boolean stackable = itemStack.k();
        crq firstEmpty = null;
        int n2 = index = topDown ? rangeHigh - 1 : rangeLow;
        while (!itemStack.e() && (topDown ? index >= rangeLow : index < rangeHigh)) {
            crq slot = (crq)this.i.get(index);
            if (!slot.f() && slot.a(itemStack)) {
                if (slot.h()) {
                    if (stackable) {
                        modified |= OpenChestMenu.addToExistingStack(itemStack, slot);
                    }
                } else {
                    if (firstEmpty == null) {
                        firstEmpty = slot;
                    }
                    if (!stackable) break;
                }
            }
            index += topDown ? -1 : 1;
        }
        if (!itemStack.e() && firstEmpty != null) {
            firstEmpty.e(itemStack.a(Math.min(itemStack.H(), firstEmpty.a_(itemStack))));
            firstEmpty.c();
            modified = true;
        }
        return modified;
    }

    private static boolean addToExistingStack(cuq itemStack, crq slot) {
        cuq existing = slot.g();
        if (!cuq.c((cuq)itemStack, (cuq)existing)) {
            return false;
        }
        int max = slot.a_(existing);
        int existingCount = existing.H();
        if (existingCount >= max) {
            return false;
        }
        int total = existingCount + itemStack.H();
        if (total <= max) {
            itemStack.e(0);
            existing.e(total);
            slot.c();
            return true;
        }
        itemStack.h(max - existingCount);
        existing.e(max);
        slot.c();
        return true;
    }

    public void a(int i, int j, cqe clickType, cmx player) {
        if (this.viewOnly) {
            if (clickType == cqe.f) {
                this.b();
            }
            return;
        }
        super.a(i, j, clickType, player);
    }

    public boolean b(cmx player) {
        return true;
    }

    protected crq a(crq slot) {
        slot.d = this.i.size();
        this.i.add((Object)slot);
        this.l.add((Object)cuq.l);
        this.o.add((Object)cuq.l);
        return slot;
    }

    protected cqn a(cqn dataSlot) {
        this.dataSlots.add(dataSlot);
        this.remoteDataSlots.add(0);
        return dataSlot;
    }

    protected void a(cqf containerData) {
        for (int i = 0; i < containerData.a(); ++i) {
            this.a(cqn.a((cqf)containerData, (int)i));
        }
    }

    public void a(cqh containerListener) {
        if (!this.containerListeners.contains(containerListener)) {
            this.containerListeners.add(containerListener);
            this.d();
        }
    }

    public void a(cqi containerSynchronizer) {
        this.synchronizer = containerSynchronizer;
        this.b();
    }

    public void b() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            cuq cuq2;
            crq slot = (crq)this.i.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                cuq2 = placeholder.getOrDefault();
            } else {
                cuq2 = slot.g();
            }
            this.o.set(index, (Object)cuq2.s());
        }
        this.remoteCarried = this.g().s();
        for (index = 0; index < this.dataSlots.size(); ++index) {
            this.remoteDataSlots.set(index, this.dataSlots.get(index).b());
        }
        if (this.synchronizer != null) {
            this.synchronizer.a((cpu)this, this.o, this.remoteCarried, this.remoteDataSlots.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        this.remoteCarried = this.g().s();
        if (this.synchronizer != null) {
            this.synchronizer.a((cpu)this, this.remoteCarried);
        }
    }

    public void b(cqh containerListener) {
        this.containerListeners.remove(containerListener);
    }

    public void d() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            cuq cuq2;
            crq slot = (crq)this.i.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                cuq2 = placeholder.getOrDefault();
            } else {
                cuq2 = slot.g();
            }
            cuq itemstack = cuq2;
            Supplier supplier = Suppliers.memoize(() -> ((cuq)itemstack).s());
            this.triggerSlotListeners(index, itemstack, (java.util.function.Supplier<cuq>)supplier);
            this.synchronizeSlotToRemote(index, itemstack, (java.util.function.Supplier<cuq>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (index = 0; index < this.dataSlots.size(); ++index) {
            cqn dataSlot = this.dataSlots.get(index);
            int j = dataSlot.b();
            if (dataSlot.c()) {
                this.updateDataSlotListeners(index, j);
            }
            this.synchronizeDataSlotToRemote(index, j);
        }
    }

    public void e() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            cuq itemstack = ((crq)this.i.get(index)).g();
            this.triggerSlotListeners(index, itemstack, () -> ((cuq)itemstack).s());
        }
        for (index = 0; index < this.dataSlots.size(); ++index) {
            cqn containerproperty = this.dataSlots.get(index);
            if (!containerproperty.c()) continue;
            this.updateDataSlotListeners(index, containerproperty.b());
        }
        this.b();
    }

    private void updateDataSlotListeners(int i, int j) {
        for (cqh containerListener : this.containerListeners) {
            containerListener.a((cpu)this, i, j);
        }
    }

    private void triggerSlotListeners(int index, cuq itemStack, java.util.function.Supplier<cuq> supplier) {
        cuq itemStack1 = (cuq)this.l.get(index);
        if (!cuq.a((cuq)itemStack1, (cuq)itemStack)) {
            cuq itemStack2 = supplier.get();
            this.l.set(index, (Object)itemStack2);
            for (cqh containerListener : this.containerListeners) {
                containerListener.a((cpu)this, index, itemStack2);
            }
        }
    }

    private void synchronizeSlotToRemote(int i, cuq itemStack, java.util.function.Supplier<cuq> supplier) {
        cuq itemStack1;
        if (!this.suppressRemoteUpdates && !cuq.a((cuq)(itemStack1 = (cuq)this.o.get(i)), (cuq)itemStack)) {
            cuq itemstack2 = supplier.get();
            this.o.set(i, (Object)itemstack2);
            if (this.synchronizer != null) {
                this.synchronizer.a((cpu)this, i, itemstack2);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int index, int value) {
        int existing;
        if (!this.suppressRemoteUpdates && (existing = this.remoteDataSlots.getInt(index)) != value) {
            this.remoteDataSlots.set(index, value);
            if (this.synchronizer != null) {
                this.synchronizer.a((cpu)this, index, value);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (!this.suppressRemoteUpdates && !cuq.a((cuq)this.g(), (cuq)this.remoteCarried)) {
            this.remoteCarried = this.g().s();
            if (this.synchronizer != null) {
                this.synchronizer.a((cpu)this, this.remoteCarried);
            }
        }
    }

    public void a(cuq itemstack) {
        this.remoteCarried = itemstack.s();
    }

    public void h() {
        this.suppressRemoteUpdates = true;
    }

    public void i() {
        this.suppressRemoteUpdates = false;
    }
}

