/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container.menu;

import com.google.common.base.Preconditions;
import com.lishid.openinv.internal.v1_21_R1.container.OpenInventory;
import com.lishid.openinv.internal.v1_21_R1.container.bukkit.OpenDummyInventory;
import com.lishid.openinv.internal.v1_21_R1.container.bukkit.OpenPlayerInventorySelf;
import com.lishid.openinv.internal.v1_21_R1.container.menu.OpenChestMenu;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentDrop;
import com.lishid.openinv.internal.v1_21_R1.container.slot.ContentEquipment;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotViewOnly;
import com.lishid.openinv.util.Permissions;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMenu
extends OpenChestMenu<OpenInventory> {
    private int offset;

    public OpenInventoryMenu(OpenInventory inventory, aqv viewer, int i, boolean viewOnly) {
        super(OpenInventoryMenu.getMenuType(inventory, viewer), i, inventory, viewer, viewOnly);
    }

    private static crc<cqc> getMenuType(OpenInventory inventory, aqv viewer) {
        int size = inventory.b();
        if (inventory.getOwnerHandle().equals((Object)viewer)) {
            size -= viewer.fY().h.size();
            size = (int)Math.ceil((double)size / 9.0) * 9;
        }
        return OpenInventoryMenu.getChestMenuType(size);
    }

    @Override
    protected void preSlotSetup() {
        this.offset = this.ownContainer ? this.viewer.fY().h.size() : 0;
    }

    @Override
    @NotNull
    protected crq getUpperSlot(int index, int x, int y) {
        crq slot = ((OpenInventory)this.container).getMenuSlot(index += this.offset, x, y);
        if (slot.getClass().equals(SlotViewOnly.class)) {
            return slot;
        }
        if (slot instanceof ContentDrop.SlotDrop && (this.viewOnly || !Permissions.INVENTORY_SLOT_DROP.hasPermission((Permissible)this.viewer.getBukkitEntity()))) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (slot instanceof ContentEquipment.SlotEquipment) {
            Permissions perm;
            ContentEquipment.SlotEquipment equipment = (ContentEquipment.SlotEquipment)slot;
            if (this.viewOnly) {
                return SlotViewOnly.wrap(slot);
            }
            switch (equipment.getEquipmentSlot()) {
                case f: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_HEAD_ANY;
                    break;
                }
                case e: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_CHEST_ANY;
                    break;
                }
                case d: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_LEGS_ANY;
                    break;
                }
                case c: {
                    Permissions permissions = Permissions.INVENTORY_SLOT_FEET_ANY;
                    break;
                }
                default: {
                    Permissions permissions = perm = null;
                }
            }
            if (perm != null && !perm.hasPermission((Permissible)this.viewer.getBukkitEntity())) {
                equipment.onlyEquipmentFor(((OpenInventory)this.container).getOwnerHandle());
            }
            return slot;
        }
        if (this.ownContainer && !(slot instanceof ContentDrop.SlotDrop)) {
            return new SlotViewOnly(this.container, index, x, y);
        }
        if (this.viewOnly) {
            return SlotViewOnly.wrap(slot);
        }
        return slot;
    }

    @Override
    @NotNull
    protected CraftInventoryView<OpenChestMenu<OpenInventory>> createBukkitEntity() {
        CraftInventory bukkitInventory = this.viewOnly ? new OpenDummyInventory(this.container) : (this.ownContainer ? new OpenPlayerInventorySelf((OpenInventory)this.container, this.offset) : ((OpenInventory)this.container).getBukkitInventory());
        return new CraftInventoryView<OpenChestMenu<OpenInventory>>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)bukkitInventory, (OpenChestMenu)this){

            public ItemStack getItem(int index) {
                if (OpenInventoryMenu.this.viewOnly || index < 0) {
                    return null;
                }
                crq slot = (crq)OpenInventoryMenu.this.i.get(index);
                return CraftItemStack.asCraftMirror((cuq)(slot.h() ? slot.g() : cuq.l));
            }

            public boolean isInTop(int rawSlot) {
                return rawSlot < OpenInventoryMenu.this.topSize;
            }

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return null;
                }
                if (rawSlot == -999 || rawSlot == -1) {
                    return null;
                }
                Preconditions.checkArgument((rawSlot >= 0 && rawSlot < OpenInventoryMenu.this.topSize + OpenInventoryMenu.this.offset + 36 ? 1 : 0) != 0, (String)"Slot %s outside of inventory", (int)rawSlot);
                if (rawSlot > OpenInventoryMenu.this.topSize) {
                    return this.getBottomInventory();
                }
                crq slot = (crq)OpenInventoryMenu.this.i.get(rawSlot);
                if (slot.f()) {
                    return null;
                }
                return this.getTopInventory();
            }

            public int convertSlot(int rawSlot) {
                if (OpenInventoryMenu.this.viewOnly) {
                    return -999;
                }
                if (rawSlot < 0) {
                    return rawSlot;
                }
                if (rawSlot < OpenInventoryMenu.this.topSize) {
                    crq slot = (crq)OpenInventoryMenu.this.i.get(rawSlot);
                    if (slot.f()) {
                        return -999;
                    }
                    return rawSlot;
                }
                int slot = rawSlot - OpenInventoryMenu.this.topSize;
                slot = slot >= 27 ? (slot -= 27) : (slot += 9);
                return slot;
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenInventoryMenu.this.viewOnly || slot < 0) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                if (slot >= OpenInventoryMenu.this.topSize) {
                    if ((slot -= OpenInventoryMenu.this.topSize) >= 27) {
                        return InventoryType.SlotType.QUICKBAR;
                    }
                    return InventoryType.SlotType.CONTAINER;
                }
                return ((OpenInventory)OpenInventoryMenu.this.container).getSlotType(OpenInventoryMenu.this.offset + slot);
            }

            public int countSlots() {
                return OpenInventoryMenu.this.topSize + 36;
            }
        };
    }

    public cuq b(cmx player, int index) {
        if (this.viewOnly) {
            return cuq.l;
        }
        crq slot = (crq)this.i.get(index);
        if (!slot.h() || slot.f()) {
            return cuq.l;
        }
        cuq itemStack = slot.g();
        cuq originalStack = itemStack.s();
        if (index < this.topSize) {
            if (!this.a(itemStack, this.topSize, this.i.size(), true)) {
                return cuq.l;
            }
        } else {
            boolean movedGear;
            bsy equipmentSlot = player.h(itemStack);
            block0 : switch (equipmentSlot) {
                case f: 
                case e: 
                case d: 
                case c: 
                case b: {
                    boolean bl;
                    for (int extra = ((OpenInventory)this.container).getOwnerHandle().fY().h.size() - this.offset; extra < this.topSize; ++extra) {
                        ContentEquipment.SlotEquipment equipSlot;
                        crq extraSlot = this.b(extra);
                        if (!(extraSlot instanceof ContentEquipment.SlotEquipment) || (equipSlot = (ContentEquipment.SlotEquipment)extraSlot).getEquipmentSlot() != equipmentSlot) continue;
                        bl = this.a(itemStack, extra, extra + 1, false);
                        break block0;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = movedGear = false;
                }
            }
            if (this.offset != 0 ? !movedGear : !movedGear && !this.a(itemStack, 0, ((OpenInventory)this.container).getOwnerHandle().fY().h.size(), true)) {
                return cuq.l;
            }
        }
        if (itemStack.e()) {
            slot.e(cuq.l);
        } else {
            slot.c();
        }
        return originalStack;
    }
}

