/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.player;

import com.lishid.openinv.event.OpenEvents;
import com.lishid.openinv.internal.v1_21_R1.player.PlayerManager;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayer
extends CraftPlayer {
    private static final Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "Passengers", "warden_spawn_tracker", "enteredNetherPosition", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "raid_omen_position", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "current_explosion_impact_pos", "active_effects", "SleepingX", "SleepingY", "SleepingZ", "Brain");
    private final PlayerManager manager;

    OpenPlayer(CraftServer server, aqv entity, PlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData(this.getHandle());
    }

    public void saveData() {
        if (OpenEvents.saveCancelled((Player)this)) {
            return;
        }
        aqv player = this.getHandle();
        try {
            eri worldNBTStorage = player.d.ah().t;
            ub oldData = this.isOnline() ? null : (ub)worldNBTStorage.load(player.ah().getString(), player.cA()).orElse(null);
            ub playerData = this.getWritableTag(oldData);
            playerData = player.f(playerData);
            this.setExtraData(playerData);
            if (oldData != null) {
                this.revertSpecialValues(playerData, oldData);
            }
            Path playerDataDir = worldNBTStorage.getPlayerDir().toPath();
            Path tempFile = Files.createTempFile(playerDataDir, player.cA() + "-", ".dat", new FileAttribute[0]);
            uo.a((ub)playerData, (Path)tempFile);
            Path dataFile = playerDataDir.resolve(player.cA() + ".dat");
            Path backupFile = playerDataDir.resolve(player.cA() + ".dat_old");
            ad.a((Path)dataFile, (Path)tempFile, (Path)backupFile);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.cB(), (Object)e);
        }
    }

    @Contract(value="null -> new")
    @NotNull
    private ub getWritableTag(@Nullable ub oldData) {
        if (oldData == null) {
            return new ub();
        }
        oldData = oldData.i();
        oldData.e().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit"));
        return oldData;
    }

    private void revertSpecialValues(@NotNull ub newData, @NotNull ub oldData) {
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", ur.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", ur.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", ur.class);
    }

    private <T extends uy> void copyValue(@NotNull ub source, @NotNull ub target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        ub oldContainer = this.getTag(source, container, ub.class);
        ub newContainer = this.getTag(target, container, ub.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends uy> T getTag(@Nullable ub container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        uy value = container.c(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((uy)dataType.cast(value));
    }

    private <T extends uy> void setTag(@NotNull ub container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            container.r(key);
        } else {
            container.a(key, data);
        }
    }
}

