/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container;

import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.jetbrains.annotations.NotNull;

public final class Placeholders {
    private static final CustomModelData DEFAULT_CUSTOM_MODEL_DATA = new CustomModelData(9999);
    @NotNull
    public static final EnumMap<EnumGamemode, ItemStack> BLOCKED_GAME_TYPE = new EnumMap(EnumGamemode.class);
    @NotNull
    public static ItemStack craftingOutput = Placeholders.defaultCraftingOutput();
    @NotNull
    public static ItemStack cursor = Placeholders.defaultCursor();
    @NotNull
    public static ItemStack drop = Placeholders.defaultDrop();
    @NotNull
    public static ItemStack emptyHelmet = Placeholders.getEmptyArmor((IMaterial)Items.py);
    @NotNull
    public static ItemStack emptyChestplate = Placeholders.getEmptyArmor((IMaterial)Items.pz);
    @NotNull
    public static ItemStack emptyLeggings = Placeholders.getEmptyArmor((IMaterial)Items.pA);
    @NotNull
    public static ItemStack emptyBoots = Placeholders.getEmptyArmor((IMaterial)Items.pB);
    @NotNull
    public static ItemStack emptyOffHand = Placeholders.getEmptyShield();
    @NotNull
    public static ItemStack notSlot = Placeholders.defaultNotSlot();
    @NotNull
    public static ItemStack blockedOffline = Placeholders.defaultBlockedOffline();

    public static void load(@NotNull ConfigurationSection section) throws Exception {
        craftingOutput = Placeholders.parse(section, "crafting-output", craftingOutput);
        cursor = Placeholders.parse(section, "cursor", cursor);
        drop = Placeholders.parse(section, "drop", drop);
        emptyHelmet = Placeholders.parse(section, "empty-helmet", emptyHelmet);
        emptyChestplate = Placeholders.parse(section, "empty-chestplate", emptyChestplate);
        emptyLeggings = Placeholders.parse(section, "empty-leggings", emptyLeggings);
        emptyBoots = Placeholders.parse(section, "empty-boots", emptyBoots);
        emptyOffHand = Placeholders.parse(section, "empty-off-hand", emptyOffHand);
        notSlot = Placeholders.parse(section, "not-a-slot", notSlot);
        blockedOffline = Placeholders.parse(section, "blocked.offline", blockedOffline);
        BLOCKED_GAME_TYPE.put(EnumGamemode.b, Placeholders.parse(section, "blocked.creative", BLOCKED_GAME_TYPE.get(EnumGamemode.b)));
        BLOCKED_GAME_TYPE.put(EnumGamemode.d, Placeholders.parse(section, "blocked.spectator", BLOCKED_GAME_TYPE.get(EnumGamemode.d)));
    }

    @NotNull
    private static ItemStack parse(@NotNull ConfigurationSection section, @NotNull String path, @NotNull ItemStack defaultStack) throws Exception {
        String itemText = section.getString(path);
        if (itemText == null) {
            return defaultStack;
        }
        NBTTagCompound compoundTag = MojangsonParser.a((String)itemText);
        Optional parsed = ItemStack.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry(), (NBTBase)compoundTag);
        return parsed.filter(itemStack -> !itemStack.e()).orElse(defaultStack);
    }

    public static ItemStack survivalOnly(@NotNull EntityPlayer serverPlayer) {
        if (serverPlayer.c == null || serverPlayer.c.isDisconnected()) {
            return blockedOffline;
        }
        return BLOCKED_GAME_TYPE.getOrDefault(serverPlayer.e.b(), ItemStack.l);
    }

    private static ItemStack defaultCraftingOutput() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.eO);
        itemStack.b(DataComponents.h, (Object)IChatBaseComponent.c((String)"container.crafting"));
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        return itemStack;
    }

    private static ItemStack defaultCursor() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.uP);
        IRegistryCustom minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        IRegistry bannerPatterns = minecraftRegistry.d(Registries.d);
        EnumBannerPatternType halfDiagBottomRight = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.v);
        EnumBannerPatternType downRight = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.l);
        EnumBannerPatternType border = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.E);
        itemStack.b(DataComponents.Y, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.b(bannerPatterns.e((Object)halfDiagBottomRight), EnumColor.h), new BannerPatternLayers.b(bannerPatterns.e((Object)downRight), EnumColor.a), new BannerPatternLayers.b(bannerPatterns.e((Object)border), EnumColor.h))));
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        itemStack.b(DataComponents.q, (Object)Unit.a);
        return itemStack;
    }

    private static ItemStack defaultDrop() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.lT);
        itemStack.b(DataComponents.h, (Object)IChatBaseComponent.c((String)"key.drop"));
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        return itemStack;
    }

    private static ItemStack getEmptyArmor(IMaterial item) {
        ItemStack itemStack = new ItemStack(item);
        DyedItemColor color = new DyedItemColor(0xC8C8C8, false);
        itemStack.b(DataComponents.z, (Object)color);
        itemStack.b(DataComponents.q, (Object)Unit.a);
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        return itemStack;
    }

    private static ItemStack getEmptyShield() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.vs);
        itemStack.b(DataComponents.Z, (Object)EnumColor.c);
        IRegistryCustom minecraftRegistry = CraftRegistry.getMinecraftRegistry();
        IRegistry bannerPatterns = minecraftRegistry.d(Registries.d);
        EnumBannerPatternType halfLeft = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.A);
        EnumBannerPatternType topLeft = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.d);
        EnumBannerPatternType topRight = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.e);
        EnumBannerPatternType bottomLeft = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.b);
        EnumBannerPatternType bottomRight = (EnumBannerPatternType)bannerPatterns.f(BannerPatterns.c);
        itemStack.b(DataComponents.Y, (Object)new BannerPatternLayers(List.of(new BannerPatternLayers.b(bannerPatterns.e((Object)halfLeft), EnumColor.p), new BannerPatternLayers.b(bannerPatterns.e((Object)topLeft), EnumColor.c), new BannerPatternLayers.b(bannerPatterns.e((Object)bottomLeft), EnumColor.c), new BannerPatternLayers.b(bannerPatterns.e((Object)topRight), EnumColor.p), new BannerPatternLayers.b(bannerPatterns.e((Object)bottomRight), EnumColor.p))));
        itemStack.b(DataComponents.q, (Object)Unit.a);
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        return itemStack;
    }

    private static ItemStack defaultNotSlot() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.it);
        itemStack.b(DataComponents.q, (Object)Unit.a);
        itemStack.b(DataComponents.o, (Object)DEFAULT_CUSTOM_MODEL_DATA);
        return itemStack;
    }

    private static ItemStack defaultBlockedOffline() {
        ItemStack itemStack = new ItemStack((IMaterial)Items.hB);
        itemStack.b(DataComponents.h, (Object)IChatBaseComponent.c((String)"options.narrator.notavailable").b((IChatBaseComponent)IChatBaseComponent.b((String)" - ")).b((IChatBaseComponent)IChatBaseComponent.c((String)"gui.socialInteractions.status_offline")));
        return itemStack;
    }

    private Placeholders() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }

    static {
        for (EnumGamemode type : EnumGamemode.values()) {
            ItemStack typeItem = new ItemStack((IMaterial)Items.hB);
            typeItem.b(DataComponents.h, (Object)IChatBaseComponent.c((String)"options.narrator.notavailable").f(" - ").b(type.e()));
            BLOCKED_GAME_TYPE.put(type, typeItem);
        }
    }
}

