/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.v1_21_R1.container.bukkit.OpenDummyInventory;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotPlaceholder;
import com.lishid.openinv.internal.v1_21_R1.container.slot.SlotViewOnly;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenChestMenu<T extends IInventory & ISpecialInventory>
extends Container {
    protected static final int BOTTOM_INVENTORY_SIZE = 36;
    protected final T container;
    protected final EntityPlayer viewer;
    protected final boolean viewOnly;
    protected final boolean ownContainer;
    protected final int topSize;
    private CraftInventoryView<OpenChestMenu<T>> bukkitEntity;
    @Nullable
    private ContainerSynchronizer synchronizer;
    private final List<ContainerProperty> dataSlots = new ArrayList<ContainerProperty>();
    private final IntList remoteDataSlots = new IntArrayList();
    private final List<ICrafting> containerListeners = new ArrayList<ICrafting>();
    private ItemStack remoteCarried = ItemStack.l;
    private boolean suppressRemoteUpdates;

    protected OpenChestMenu(@NotNull Containers<ContainerChest> type, int containerCounter, @NotNull T container, @NotNull EntityPlayer viewer, boolean viewOnly) {
        super(type, containerCounter);
        int y;
        int x;
        int col;
        this.container = container;
        this.viewer = viewer;
        this.viewOnly = viewOnly;
        this.ownContainer = ((EntityPlayer)((InternalOwned)container).getOwnerHandle()).equals((Object)viewer);
        this.topSize = this.getTopSize(viewer);
        this.preSlotSetup();
        int upperRows = this.topSize / 9;
        for (int row = 0; row < upperRows; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                y = 18 + row * 18;
                int index = row * 9 + col;
                if (index >= container.b()) {
                    this.a(new SlotViewOnly((IInventory)container, index, x, y));
                    continue;
                }
                Slot slot = this.getUpperSlot(index, x, y);
                this.a(slot);
            }
        }
        int playerInvPad = (upperRows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int x2 = 8 + col2 * 18;
                int y2 = playerInvPad + row * 18 + 103;
                this.a(new Slot((IInventory)viewer.fY(), row * 9 + col2 + 9, x2, y2));
            }
        }
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            y = playerInvPad + 161;
            this.a(new Slot((IInventory)viewer.fY(), col, x, y));
        }
    }

    @NotNull
    public static Containers<ContainerChest> getChestMenuType(int inventorySize) {
        inventorySize = (int)Math.ceil((double)inventorySize / 9.0) * 9;
        return switch (inventorySize) {
            case 9 -> Containers.a;
            case 18 -> Containers.b;
            case 27 -> Containers.c;
            case 36 -> Containers.d;
            case 45 -> Containers.e;
            case 54 -> Containers.f;
            default -> throw new IllegalArgumentException("Inventory size unsupported: " + inventorySize);
        };
    }

    protected void preSlotSetup() {
    }

    @NotNull
    protected Slot getUpperSlot(int index, int x, int y) {
        if (this.viewOnly) {
            return new SlotViewOnly((IInventory)this.container, index, x, y);
        }
        return new Slot(this.container, index, x, y);
    }

    @NotNull
    public final CraftInventoryView<OpenChestMenu<T>> getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = this.createBukkitEntity();
        }
        return this.bukkitEntity;
    }

    @NotNull
    protected CraftInventoryView<OpenChestMenu<T>> createBukkitEntity() {
        Object top = this.viewOnly ? new OpenDummyInventory((IInventory)this.container) : ((ISpecialInventory)this.container).getBukkitInventory();
        return new CraftInventoryView<OpenChestMenu<T>>((HumanEntity)this.viewer.getBukkitEntity(), (Inventory)top, this){

            @Nullable
            public Inventory getInventory(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return null;
                }
                return super.getInventory(rawSlot);
            }

            public int convertSlot(int rawSlot) {
                if (OpenChestMenu.this.viewOnly) {
                    return -999;
                }
                return super.convertSlot(rawSlot);
            }

            @NotNull
            public InventoryType.SlotType getSlotType(int slot) {
                if (OpenChestMenu.this.viewOnly) {
                    return InventoryType.SlotType.OUTSIDE;
                }
                return super.getSlotType(slot);
            }
        };
    }

    private int getTopSize(EntityPlayer viewer) {
        Containers menuType = this.a();
        if (menuType == null) {
            throw new IllegalStateException("MenuType cannot be null!");
        }
        if (menuType == Containers.a) {
            return 9;
        }
        if (menuType == Containers.b) {
            return 18;
        }
        if (menuType == Containers.c) {
            return 27;
        }
        if (menuType == Containers.d) {
            return 36;
        }
        if (menuType == Containers.e) {
            return 45;
        }
        if (menuType == Containers.f) {
            return 54;
        }
        return menuType.a((int)-1, (PlayerInventory)viewer.fY()).i.size() - 36;
    }

    protected boolean a(ItemStack itemStack, int rangeLow, int rangeHigh, boolean topDown) {
        int index;
        boolean modified = false;
        boolean stackable = itemStack.k();
        Slot firstEmpty = null;
        int n = index = topDown ? rangeHigh - 1 : rangeLow;
        while (!itemStack.e() && (topDown ? index >= rangeLow : index < rangeHigh)) {
            Slot slot = (Slot)this.i.get(index);
            if (!slot.f() && slot.a(itemStack)) {
                if (slot.h()) {
                    if (stackable) {
                        modified |= OpenChestMenu.addToExistingStack(itemStack, slot);
                    }
                } else {
                    if (firstEmpty == null) {
                        firstEmpty = slot;
                    }
                    if (!stackable) break;
                }
            }
            index += topDown ? -1 : 1;
        }
        if (!itemStack.e() && firstEmpty != null) {
            firstEmpty.e(itemStack.a(Math.min(itemStack.H(), firstEmpty.a_(itemStack))));
            firstEmpty.c();
            modified = true;
        }
        return modified;
    }

    private static boolean addToExistingStack(ItemStack itemStack, Slot slot) {
        ItemStack existing = slot.g();
        if (!ItemStack.c((ItemStack)itemStack, (ItemStack)existing)) {
            return false;
        }
        int max = slot.a_(existing);
        int existingCount = existing.H();
        if (existingCount >= max) {
            return false;
        }
        int total = existingCount + itemStack.H();
        if (total <= max) {
            itemStack.e(0);
            existing.e(total);
            slot.c();
            return true;
        }
        itemStack.h(max - existingCount);
        existing.e(max);
        slot.c();
        return true;
    }

    public void a(int i, int j, InventoryClickType clickType, EntityHuman player) {
        if (this.viewOnly) {
            if (clickType == InventoryClickType.f) {
                this.b();
            }
            return;
        }
        super.a(i, j, clickType, player);
    }

    public boolean b(EntityHuman player) {
        return true;
    }

    protected Slot a(Slot slot) {
        slot.d = this.i.size();
        this.i.add((Object)slot);
        this.l.add((Object)ItemStack.l);
        this.o.add((Object)ItemStack.l);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty dataSlot) {
        this.dataSlots.add(dataSlot);
        this.remoteDataSlots.add(0);
        return dataSlot;
    }

    protected void a(IContainerProperties containerData) {
        for (int i = 0; i < containerData.a(); ++i) {
            this.a(ContainerProperty.a((IContainerProperties)containerData, (int)i));
        }
    }

    public void a(ICrafting containerListener) {
        if (!this.containerListeners.contains(containerListener)) {
            this.containerListeners.add(containerListener);
            this.d();
        }
    }

    public void a(ContainerSynchronizer containerSynchronizer) {
        this.synchronizer = containerSynchronizer;
        this.b();
    }

    public void b() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            ItemStack itemStack;
            Slot slot = (Slot)this.i.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                itemStack = placeholder.getOrDefault();
            } else {
                itemStack = slot.g();
            }
            this.o.set(index, (Object)itemStack.s());
        }
        this.remoteCarried = this.g().s();
        for (index = 0; index < this.dataSlots.size(); ++index) {
            this.remoteDataSlots.set(index, this.dataSlots.get(index).b());
        }
        if (this.synchronizer != null) {
            this.synchronizer.a((Container)this, this.o, this.remoteCarried, this.remoteDataSlots.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        this.remoteCarried = this.g().s();
        if (this.synchronizer != null) {
            this.synchronizer.a((Container)this, this.remoteCarried);
        }
    }

    public void b(ICrafting containerListener) {
        this.containerListeners.remove(containerListener);
    }

    public void d() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            ItemStack itemStack;
            Slot slot = (Slot)this.i.get(index);
            if (slot instanceof SlotPlaceholder) {
                SlotPlaceholder placeholder = (SlotPlaceholder)slot;
                itemStack = placeholder.getOrDefault();
            } else {
                itemStack = slot.g();
            }
            ItemStack itemstack = itemStack;
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).s());
            this.triggerSlotListeners(index, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(index, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (index = 0; index < this.dataSlots.size(); ++index) {
            ContainerProperty dataSlot = this.dataSlots.get(index);
            int j = dataSlot.b();
            if (dataSlot.c()) {
                this.updateDataSlotListeners(index, j);
            }
            this.synchronizeDataSlotToRemote(index, j);
        }
    }

    public void e() {
        int index;
        for (index = 0; index < this.i.size(); ++index) {
            ItemStack itemstack = ((Slot)this.i.get(index)).g();
            this.triggerSlotListeners(index, itemstack, () -> ((ItemStack)itemstack).s());
        }
        for (index = 0; index < this.dataSlots.size(); ++index) {
            ContainerProperty containerproperty = this.dataSlots.get(index);
            if (!containerproperty.c()) continue;
            this.updateDataSlotListeners(index, containerproperty.b());
        }
        this.b();
    }

    private void updateDataSlotListeners(int i, int j) {
        for (ICrafting containerListener : this.containerListeners) {
            containerListener.a((Container)this, i, j);
        }
    }

    private void triggerSlotListeners(int index, ItemStack itemStack, java.util.function.Supplier<ItemStack> supplier) {
        ItemStack itemStack1 = (ItemStack)this.l.get(index);
        if (!ItemStack.a((ItemStack)itemStack1, (ItemStack)itemStack)) {
            ItemStack itemStack2 = supplier.get();
            this.l.set(index, (Object)itemStack2);
            for (ICrafting containerListener : this.containerListeners) {
                containerListener.a((Container)this, index, itemStack2);
            }
        }
    }

    private void synchronizeSlotToRemote(int i, ItemStack itemStack, java.util.function.Supplier<ItemStack> supplier) {
        ItemStack itemStack1;
        if (!this.suppressRemoteUpdates && !ItemStack.a((ItemStack)(itemStack1 = (ItemStack)this.o.get(i)), (ItemStack)itemStack)) {
            ItemStack itemstack2 = supplier.get();
            this.o.set(i, (Object)itemstack2);
            if (this.synchronizer != null) {
                this.synchronizer.a((Container)this, i, itemstack2);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int index, int value) {
        int existing;
        if (!this.suppressRemoteUpdates && (existing = this.remoteDataSlots.getInt(index)) != value) {
            this.remoteDataSlots.set(index, value);
            if (this.synchronizer != null) {
                this.synchronizer.a((Container)this, index, value);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (!this.suppressRemoteUpdates && !ItemStack.a((ItemStack)this.g(), (ItemStack)this.remoteCarried)) {
            this.remoteCarried = this.g().s();
            if (this.synchronizer != null) {
                this.synchronizer.a((Container)this, this.remoteCarried);
            }
        }
    }

    public void a(ItemStack itemstack) {
        this.remoteCarried = itemstack.s();
    }

    public void h() {
        this.suppressRemoteUpdates = true;
    }

    public void i() {
        this.suppressRemoteUpdates = false;
    }
}

