/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.janus;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends JavaPlugin
implements Listener {
    private static final Material FRAME = Material.OBSIDIAN;
    private static final Material SIGN = Material.WALL_SIGN;
    private boolean portalTurnPlayer = false;
    private int portalDistance = 3;
    private boolean blockMessages = false;
    private String noPermission = "You don't have permission to use Server Portals!";
    private String signIdentifier = "server";
    HashSet<UUID> enteredPortal = new HashSet();

    public void onEnable() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getConfig().addDefault("portalTurnPlayer", (Object)this.portalTurnPlayer);
        this.getConfig().addDefault("portalDistance", (Object)this.portalDistance);
        this.getConfig().addDefault("blockMessages", (Object)this.blockMessages);
        this.getConfig().addDefault("noPermission", (Object)this.noPermission);
        this.getConfig().addDefault("signIdentifier", (Object)this.signIdentifier);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.portalTurnPlayer = this.getConfig().getBoolean("portalFlippPlayer");
        this.portalDistance = this.getConfig().getInt("portalDistance");
        if (this.portalDistance < 1) {
            this.portalDistance = 1;
        }
        this.blockMessages = this.getConfig().getBoolean("blockMessages");
        this.noPermission = this.getConfig().getString("noPermission");
        this.signIdentifier = this.getConfig().getString("signIdentifier").toLowerCase();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.blockMessages) {
            event.setJoinMessage(null);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.blockMessages) {
            event.setQuitMessage(null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (event.getLine(0).toLowerCase().equals("[" + this.signIdentifier + "]") && !event.getPlayer().hasPermission("janus.sign")) {
            event.getPlayer().sendMessage(ChatColor.RED + "You are not allowed to do that!");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerPortalEnter(EntityPortalEnterEvent event) {
        UUID id;
        if (event.getEntityType() == EntityType.PLAYER && !this.enteredPortal.contains(id = event.getEntity().getUniqueId())) {
            this.enteredPortal.add(id);
            block2: for (Block block : this.getPortalNear(event.getLocation())) {
                for (BlockFace bf : BlockFace.values()) {
                    Sign sign;
                    Block relative = block.getRelative(bf);
                    if (relative.getType() != SIGN || !(sign = (Sign)relative.getState()).getLine(0).toLowerCase().equals("[" + this.signIdentifier + "]")) continue;
                    Player player = (Player)event.getEntity();
                    if (!player.hasPermission("janus.use")) {
                        player.sendMessage(ChatColor.RED + this.noPermission);
                        continue block2;
                    }
                    Location location = player.getLocation();
                    float originalPitch = location.getPitch();
                    location.setPitch(0.0f);
                    Vector vec = location.getDirection().multiply(this.portalDistance);
                    location = location.add(vec.multiply(-1));
                    location.setPitch(originalPitch);
                    if (this.portalTurnPlayer) {
                        float f;
                        float yaw = location.getYaw();
                        yaw += 180.0f;
                        if (f > 360.0f) {
                            yaw -= 360.0f;
                        }
                        location.setYaw(yaw);
                    }
                    player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(b);
                    try {
                        out.writeUTF("Connect");
                        out.writeUTF(sign.getLine(1));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    player.sendPluginMessage((Plugin)this, "BungeeCord", b.toByteArray());
                    continue block2;
                }
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                public void run() {
                    Main.this.enteredPortal.remove(id);
                }
            }, 20L);
        }
    }

    private Set<Block> getPortalNear(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        int b0 = 0;
        int b1 = 0;
        if (world.getBlockAt(x - 1, y, z).getType() == FRAME || world.getBlockAt(x + 1, y, z).getType() == FRAME) {
            b0 = 1;
        }
        if (world.getBlockAt(x, y, z - 1).getType() == FRAME || world.getBlockAt(x, y, z + 1).getType() == FRAME) {
            b1 = 1;
        }
        HashSet<Block> blocks = new HashSet<Block>();
        if (world.getBlockAt(x - b0, y, z - b1).getType() == Material.AIR) {
            x -= b0;
            z -= b1;
        }
        for (int i = -1; i <= 2; i = (int)((byte)(i + 1))) {
            for (int j = -1; j <= 3; j = (int)((byte)(j + 1))) {
                boolean flag;
                boolean bl = flag = i == -1 || i == 2 || j == -1 || j == 3;
                if ((i == -1 || i == 2) && (j == -1 || j == 3) || !flag) continue;
                blocks.add(world.getBlockAt(x + b0 * i, y + j, z + b1 * i));
            }
        }
        return blocks;
    }
}

