/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.api.events;

import com.google.common.base.Preconditions;
import com.nisovin.shopkeepers.api.events.ShopkeeperEvent;
import com.nisovin.shopkeepers.api.shopkeeper.player.PlayerShopkeeper;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PlayerShopkeeperHireEvent
extends ShopkeeperEvent
implements Cancellable {
    private final @UnknownKeyFor @NonNull @Initialized Player player;
    private final @Nullable @UnknownKeyFor @Initialized ItemStack @UnknownKeyFor @NonNull @Initialized [] newPlayerInventoryContents;
    private @UnknownKeyFor @NonNull @Initialized int maxShopsLimit;
    private @UnknownKeyFor @NonNull @Initialized boolean cancelled = false;
    private static final @UnknownKeyFor @NonNull @Initialized HandlerList handlers = new HandlerList();

    public PlayerShopkeeperHireEvent(@UnknownKeyFor @NonNull @Initialized PlayerShopkeeper shopkeeper, @UnknownKeyFor @NonNull @Initialized Player player, @Nullable @UnknownKeyFor @Initialized ItemStack @UnknownKeyFor @NonNull @Initialized [] newPlayerInventoryContents, @UnknownKeyFor @NonNull @Initialized int maxShopsLimit) {
        super(shopkeeper);
        Preconditions.checkNotNull((Object)player, (Object)"player is null");
        Preconditions.checkNotNull((Object)newPlayerInventoryContents, (Object)"newPlayerInventoryContents is null");
        Preconditions.checkArgument((maxShopsLimit >= 0 ? 1 : 0) != 0, (Object)"maxShopsLimit cannot be negative");
        this.player = player;
        this.newPlayerInventoryContents = newPlayerInventoryContents;
        this.maxShopsLimit = maxShopsLimit;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PlayerShopkeeper getShopkeeper() {
        return (PlayerShopkeeper)super.getShopkeeper();
    }

    public @UnknownKeyFor @NonNull @Initialized Player getPlayer() {
        return this.player;
    }

    public @Nullable @UnknownKeyFor @Initialized ItemStack @UnknownKeyFor @NonNull @Initialized [] getNewPlayerInventoryContents() {
        return this.newPlayerInventoryContents;
    }

    public @UnknownKeyFor @NonNull @Initialized int getMaxShopsLimit() {
        return this.maxShopsLimit;
    }

    public void setMaxShopsLimit(@UnknownKeyFor @NonNull @Initialized int maxShopsLimit) {
        Preconditions.checkArgument((maxShopsLimit >= 0 ? 1 : 0) != 0, (Object)"maxShopsLimit cannot be negative");
        this.maxShopsLimit = maxShopsLimit;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(@UnknownKeyFor @NonNull @Initialized boolean cancelled) {
        this.cancelled = cancelled;
    }

    public @UnknownKeyFor @NonNull @Initialized HandlerList getHandlers() {
        return handlers;
    }

    public static @UnknownKeyFor @NonNull @Initialized HandlerList getHandlerList() {
        return handlers;
    }
}

