/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.api.internal.util;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Unsafe {
    public static <T> T cast(@UnknownInitialization @Nullable @UnknownKeyFor Object object) {
        return (T)object;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@UnknownInitialization @Nullable @UnknownKeyFor Object object) {
        assert (object != null) : "@AssumeAssertion(nullness)";
        return Unsafe.cast(object);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T assertNonNull(@Nullable T object) {
        assert (object != null) : "@AssumeAssertion(nullness)";
        return Unsafe.cast(object);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @Initialized @NonNull T initialized(@UnknownInitialization @Nullable T object) {
        assert (object != null) : "@AssumeAssertion(nullness)";
        return Unsafe.cast(object);
    }

    public static <T> @Nullable T nullable(@Nullable T object) {
        return object;
    }

    public static <T> @NonNull T uncheckedNull() {
        return Unsafe.cast(null);
    }

    public static <T> @NonNull T nullableAsNonNull(@Nullable T object) {
        return Unsafe.cast(object);
    }

    private Unsafe() {
    }
}

