/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.api.shopkeeper;

import com.google.common.base.Preconditions;
import com.nisovin.shopkeepers.api.shopkeeper.ShopType;
import com.nisovin.shopkeepers.api.shopobjects.ShopObjectType;
import com.nisovin.shopkeepers.api.shopobjects.virtual.VirtualShopObjectType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ShopCreationData {
    private final @Nullable @UnknownKeyFor @Initialized Player creator;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> shopType;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopObjectType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> shopObjectType;
    private @Nullable @UnknownKeyFor @Initialized Location spawnLocation;
    private @Nullable @UnknownKeyFor @Initialized BlockFace targetedBlockFace;
    private @Nullable @UnknownKeyFor @Initialized Map<@NonNull @UnknownKeyFor @Initialized String, @NonNull @UnknownKeyFor @Initialized Object> additionalData;

    protected ShopCreationData(@Nullable @UnknownKeyFor @Initialized Player creator, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> shopType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopObjectType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> shopObjectType, @Nullable @UnknownKeyFor @Initialized Location spawnLocation, @Nullable @UnknownKeyFor @Initialized BlockFace targetedBlockFace) {
        Preconditions.checkNotNull(shopType, (Object)"shopType is null");
        Preconditions.checkNotNull(shopObjectType, (Object)"shopObjectType is null");
        this.creator = creator;
        this.shopType = shopType;
        this.shopObjectType = shopObjectType;
        if (spawnLocation != null) {
            Preconditions.checkNotNull((Object)spawnLocation.getWorld(), (Object)"spawnLocation has no world");
            spawnLocation.checkFinite();
            this.spawnLocation = spawnLocation.clone();
        } else {
            Preconditions.checkArgument((boolean)(shopObjectType instanceof VirtualShopObjectType), (Object)"spawnLocation is null, but the shop object type is not virtual");
            this.spawnLocation = null;
        }
        this.targetedBlockFace = targetedBlockFace;
    }

    public @Nullable @UnknownKeyFor @Initialized Player getCreator() {
        return this.creator;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getShopType() {
        return this.shopType;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ShopObjectType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getShopObjectType() {
        return this.shopObjectType;
    }

    public @Nullable @UnknownKeyFor @Initialized Location getSpawnLocation() {
        return this.spawnLocation != null ? this.spawnLocation.clone() : null;
    }

    public void setSpawnLocation(@Nullable @UnknownKeyFor @Initialized Location newSpawnLocation) {
        if (!(this.shopObjectType instanceof VirtualShopObjectType)) {
            Preconditions.checkNotNull((Object)newSpawnLocation, (Object)"newSpawnLocation is null, but the shop object type is not virtual");
        }
        if (newSpawnLocation == null) {
            this.spawnLocation = null;
        } else {
            Preconditions.checkNotNull((Object)newSpawnLocation.getWorld(), (Object)"newSpawnLocation has no world");
            newSpawnLocation.checkFinite();
            if (this.spawnLocation != null) {
                Preconditions.checkArgument((this.spawnLocation.getWorld() == newSpawnLocation.getWorld() ? 1 : 0) != 0, (Object)"Cannot set the spawn location to a different world!");
            }
            this.spawnLocation = newSpawnLocation.clone();
        }
    }

    public @Nullable @UnknownKeyFor @Initialized BlockFace getTargetedBlockFace() {
        return this.targetedBlockFace;
    }

    public void setTargetedBlockFace(@Nullable @UnknownKeyFor @Initialized BlockFace blockFace) {
        this.targetedBlockFace = blockFace;
    }

    public <T> @Nullable T getValue(@UnknownKeyFor @NonNull @Initialized String key) {
        return (T)(this.additionalData != null ? this.additionalData.get(key) : null);
    }

    public <T> void setValue(@UnknownKeyFor @NonNull @Initialized String key, @Nullable T value) {
        if (value == null) {
            if (this.additionalData != null) {
                this.additionalData.remove(key);
            }
        } else {
            if (this.additionalData == null) {
                this.additionalData = new HashMap<String, Object>();
            }
            assert (this.additionalData != null);
            this.additionalData.put(key, value);
        }
    }
}

